/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.cucumber.crafting.ShapelessCraftingInput;
import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.ArrayUtils;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;
import thelm.packagedexcrafting.recipe.CombinationPackageRecipeType;
import thelm.packagedexcrafting.recipe.ICombinationPackageRecipeInfo;

public class CombinationPackageRecipeInfo
implements ICombinationPackageRecipeInfo {
    public static final MapCodec<CombinationPackageRecipeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(CombinationPackageRecipeInfo::getRecipeId), (App)ItemStack.OPTIONAL_CODEC.orElse((Object)ItemStack.EMPTY).fieldOf("core").forGetter(CombinationPackageRecipeInfo::getCoreInput), (App)ItemStack.OPTIONAL_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(48).fieldOf("pedestal").forGetter(CombinationPackageRecipeInfo::getPedestalInputs)).apply((Applicative)instance, CombinationPackageRecipeInfo::new));
    public static final Codec<CombinationPackageRecipeInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, CombinationPackageRecipeInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CombinationPackageRecipeInfo::getRecipeId, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, CombinationPackageRecipeInfo::getCoreInput, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, CombinationPackageRecipeInfo::getPedestalInputs, CombinationPackageRecipeInfo::new);
    private final ResourceLocation id;
    private final ICombinationRecipe recipe;
    private final ItemStack inputCore;
    private final List<ItemStack> inputPedestal;
    private final List<ItemStack> input;
    private final ItemStack output;
    private final List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public CombinationPackageRecipeInfo(ResourceLocation id, ItemStack inputCore, List<ItemStack> inputPedestal) {
        this.id = id;
        this.inputCore = inputCore;
        this.inputPedestal = inputPedestal;
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>(inputPedestal.size() + 1);
        matrixList.add(inputCore);
        matrixList.addAll(inputPedestal);
        ShapelessCraftingInput matrix = new ShapelessCraftingInput(matrixList);
        this.input = MiscHelper.INSTANCE.condenseStacks(matrixList);
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
        Recipe recipeSer = MiscHelper.INSTANCE.getRecipeManager().byKey(id).map(RecipeHolder::value).orElse(null);
        if (recipeSer instanceof ICombinationRecipe) {
            ICombinationRecipe combinationRecipe;
            this.recipe = combinationRecipe = (ICombinationRecipe)recipeSer;
            this.output = this.recipe.assemble((RecipeInput)matrix, (HolderLookup.Provider)MiscHelper.INSTANCE.getRegistryAccess()).copy();
        } else {
            this.recipe = null;
            this.output = ItemStack.EMPTY;
        }
    }

    public CombinationPackageRecipeInfo(List<ItemStack> inputs, Level level) {
        ItemStack inputCore = ItemStack.EMPTY;
        this.inputPedestal = new ArrayList<ItemStack>();
        int[] slotArray = CombinationPackageRecipeType.SLOTS.toIntArray();
        ArrayUtils.shift((int[])slotArray, (int)0, (int)25, (int)1);
        for (int i = 0; i < 49; ++i) {
            ItemStack toSet = inputs.get(slotArray[i]);
            if (toSet.isEmpty()) continue;
            toSet.setCount(1);
            if (i == 0) {
                inputCore = toSet.copy();
                continue;
            }
            this.inputPedestal.add(toSet.copy());
        }
        this.inputCore = inputCore;
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>(this.inputPedestal.size() + 1);
        matrixList.add(inputCore);
        matrixList.addAll(this.inputPedestal);
        ShapelessCraftingInput matrix = new ShapelessCraftingInput(matrixList);
        RecipeHolder recipeHolder = MiscHelper.INSTANCE.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.COMBINATION.get(), (RecipeInput)matrix, level).orElse(null);
        if (recipeHolder != null) {
            this.id = recipeHolder.id();
            this.recipe = (ICombinationRecipe)recipeHolder.value();
            this.output = this.recipe.assemble((RecipeInput)matrix, (HolderLookup.Provider)level.registryAccess()).copy();
        } else {
            this.id = null;
            this.recipe = null;
            this.output = null;
        }
        this.input = MiscHelper.INSTANCE.condenseStacks(matrixList);
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public IPackageRecipeType getRecipeType() {
        return CombinationPackageRecipeType.INSTANCE;
    }

    public boolean isValid() {
        return this.id != null && this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public ItemStack getCoreInput() {
        return this.inputCore.copy();
    }

    @Override
    public List<ItemStack> getPedestalInputs() {
        return Collections.unmodifiableList(this.inputPedestal);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.copy();
    }

    @Override
    public long getEnergyRequired() {
        return this.recipe.getPowerCost();
    }

    @Override
    public int getEnergyUsage() {
        return this.recipe.getPowerRate();
    }

    @Override
    public ICombinationRecipe getRecipe() {
        return this.recipe;
    }

    public ResourceLocation getRecipeId() {
        return this.id;
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = CombinationPackageRecipeType.SLOTS.toIntArray();
        slotArray = ArrayUtils.remove((int[])slotArray, (int)24);
        map.put(40, (Object)this.inputCore);
        for (int i = 0; i < this.inputPedestal.size(); ++i) {
            map.put(slotArray[i], (Object)this.inputPedestal.get(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CombinationPackageRecipeInfo) {
            CombinationPackageRecipeInfo other = (CombinationPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals((IPackageRecipeInfo)this, (Object)this.recipe, (IPackageRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode((IPackageRecipeInfo)this, (Object)this.recipe);
    }
}

