/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;
import thelm.packagedexcrafting.recipe.FluxPackageRecipeType;
import thelm.packagedexcrafting.recipe.IFluxPackageRecipeInfo;

public class FluxPackageRecipeInfo
implements IFluxPackageRecipeInfo {
    public static final MapCodec<FluxPackageRecipeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FluxPackageRecipeInfo::getRecipeId), (App)Codec.INT.fieldOf("width").forGetter(FluxPackageRecipeInfo::getMatrixWidth), (App)Codec.INT.fieldOf("height").forGetter(FluxPackageRecipeInfo::getMatrixHeight), (App)ItemStack.OPTIONAL_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(9).fieldOf("input").forGetter(FluxPackageRecipeInfo::getMatrixAsList)).apply((Applicative)instance, FluxPackageRecipeInfo::new));
    public static final Codec<FluxPackageRecipeInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, FluxPackageRecipeInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, FluxPackageRecipeInfo::getRecipeId, (StreamCodec)ByteBufCodecs.INT, FluxPackageRecipeInfo::getMatrixWidth, (StreamCodec)ByteBufCodecs.INT, FluxPackageRecipeInfo::getMatrixHeight, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, FluxPackageRecipeInfo::getMatrixAsList, FluxPackageRecipeInfo::new);
    private final ResourceLocation id;
    private final IFluxCrafterRecipe recipe;
    private final List<ItemStack> input;
    private final CraftingInput matrix;
    private final ItemStack output;
    private final List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public FluxPackageRecipeInfo(ResourceLocation id, int width, int height, List<ItemStack> matrixSer) {
        this.id = id;
        this.matrix = CraftingInput.of((int)width, (int)height, matrixSer);
        this.input = MiscHelper.INSTANCE.condenseStacks(this.matrix.items());
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
        Recipe recipeSer = MiscHelper.INSTANCE.getRecipeManager().byKey(id).map(RecipeHolder::value).orElse(null);
        if (recipeSer instanceof IFluxCrafterRecipe) {
            IFluxCrafterRecipe fluxRecipe;
            this.recipe = fluxRecipe = (IFluxCrafterRecipe)recipeSer;
            this.output = this.recipe.assemble((RecipeInput)this.matrix, (HolderLookup.Provider)MiscHelper.INSTANCE.getRegistryAccess()).copy();
        } else {
            this.recipe = null;
            this.output = ItemStack.EMPTY;
        }
    }

    public FluxPackageRecipeInfo(List<ItemStack> inputs, Level level) {
        NonNullList matrixList = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        int[] slotArray = FluxPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            ItemStack toSet = inputs.get(slotArray[i]);
            toSet.setCount(1);
            matrixList.set(i, (Object)toSet.copy());
        }
        this.matrix = CraftingInput.of((int)3, (int)3, (List)matrixList);
        RecipeHolder recipeHolder = MiscHelper.INSTANCE.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.FLUX_CRAFTER.get(), (RecipeInput)this.matrix, level).orElse(null);
        if (recipeHolder != null) {
            this.id = recipeHolder.id();
            this.recipe = (IFluxCrafterRecipe)recipeHolder.value();
            this.output = this.recipe.assemble((RecipeInput)this.matrix, (HolderLookup.Provider)level.registryAccess()).copy();
        } else {
            this.id = null;
            this.recipe = null;
            this.output = null;
        }
        this.input = MiscHelper.INSTANCE.condenseStacks(this.matrix.items());
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public IPackageRecipeType getRecipeType() {
        return FluxPackageRecipeType.INSTANCE;
    }

    public boolean isValid() {
        return this.id != null && this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.copy();
    }

    @Override
    public IFluxCrafterRecipe getRecipe() {
        return this.recipe;
    }

    public ResourceLocation getRecipeId() {
        return this.id;
    }

    @Override
    public CraftingInput getMatrix() {
        return this.matrix;
    }

    public List<ItemStack> getMatrixAsList() {
        return Collections.unmodifiableList(this.matrix.items());
    }

    public int getMatrixWidth() {
        return this.matrix.width();
    }

    public int getMatrixHeight() {
        return this.matrix.height();
    }

    @Override
    public int getEnergyRequired() {
        return this.recipe.getPowerRequired();
    }

    @Override
    public int getEnergyUsage() {
        return this.recipe.getPowerRate();
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return this.recipe.getRemainingItems((RecipeInput)this.matrix);
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = FluxPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < this.matrix.height(); ++i) {
            for (int j = 0; j < this.matrix.width(); ++j) {
                map.put(slotArray[i * 3 + j], (Object)this.matrix.getItem(i * this.matrix.width() + j));
            }
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FluxPackageRecipeInfo) {
            FluxPackageRecipeInfo other = (FluxPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals((IPackageRecipeInfo)this, (Object)this.recipe, (IPackageRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode((IPackageRecipeInfo)this, (Object)this.recipe);
    }
}

