/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.client.components.CursorWidget;
import com.teamresourceful.resourcefullib.client.screens.CursorScreen;
import earth.terrarium.chipped.client.screens.FakeLevel;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RenderWindowWidget
extends AbstractWidget
implements CursorWidget {
    public static final BlockPos ORIGIN = BlockPos.ZERO;
    public static final BlockPos NORTH = BlockPos.ZERO.north();
    public static final BlockPos NORTH_UP = BlockPos.ZERO.north().above();
    public static final BlockPos SOUTH = BlockPos.ZERO.south();
    public static final BlockPos UP = BlockPos.ZERO.above();
    public static final BlockPos DOWN = BlockPos.ZERO.below();
    private static final Set<BlockPos> DOOR_POSITIONS_BOTTOM = Set.of(ORIGIN);
    private static final Set<BlockPos> DOOR_POSITIONS_TOP = Set.of(UP);
    private final Supplier<Mode> mode;
    private final Supplier<@Nullable BlockState> state;
    private final FakeLevel fakeLevel = new FakeLevel();

    public RenderWindowWidget(int x, int y, int width, int height, Supplier<Mode> mode, Supplier<BlockState> state) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.mode = mode;
        this.state = state;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Mode mode = this.mode.get();
        BlockState state = this.state.get();
        if (state == null) {
            return;
        }
        boolean isDoor = state.getBlock() instanceof DoorBlock;
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            pose.translate((float)this.getX(), (float)this.getY(), 100.0f);
            pose.translate(46.0f, 46.0f, 0.0f);
            if (!isDoor) {
                pose.translate((float)mode.xOffset, (float)mode.yOffset, 0.0f);
            } else {
                pose.translate(5.0f, 12.0f, 0.0f);
            }
            pose.scale(-20.0f, -20.0f, -20.0f);
            pose.translate(0.5, 0.5, 0.5);
            pose.mulPose(Axis.XP.rotationDegrees(-30.0f));
            pose.mulPose(Axis.YP.rotationDegrees(45.0f));
            pose.translate(-0.5, -0.5, -0.5);
            this.fakeLevel.setState(state);
            if (isDoor) {
                this.fakeLevel.setPositions(DOOR_POSITIONS_BOTTOM);
                this.fakeLevel.renderBlock((PoseStack)pose);
                this.fakeLevel.setState((BlockState)state.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
                this.fakeLevel.setPositions(DOOR_POSITIONS_TOP);
                this.fakeLevel.renderBlock((PoseStack)pose);
            } else {
                this.fakeLevel.setPositions(mode.positions);
                this.fakeLevel.renderBlock((PoseStack)pose);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public CursorScreen.Cursor getCursor() {
        return CursorScreen.Cursor.DEFAULT;
    }

    public static enum Mode {
        SINGLE_BLOCK(0, 0, ORIGIN),
        HORIZONTAL_BLOCK(0, 0, ORIGIN, NORTH, SOUTH),
        VERTICAL_BLOCK(0, 0, ORIGIN, UP, DOWN),
        TWO_BY_TWO(-7, 5, ORIGIN, NORTH, UP, NORTH_UP);

        private final int xOffset;
        private final int yOffset;
        private final Set<BlockPos> positions;

        private Mode(int xOffset, int yOffset, BlockPos ... positions) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.positions = Set.of(positions);
        }
    }
}

