/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.gui;

import com.hrznstudio.emojiful.CommonClass;
import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.gui.EmojiSelectionGui;
import com.hrznstudio.emojiful.gui.EmojiSuggestionHelper;
import com.hrznstudio.emojiful.platform.Services;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.InBedChatScreen;

public class EmojifulBedChatScreen
extends InBedChatScreen {
    private EmojiSelectionGui emojiSelectionGui;
    private EmojiSuggestionHelper emojiSuggestionHelper;

    protected void init() {
        super.init();
        if (!Constants.error) {
            if (Services.CONFIG.showEmojiAutocomplete()) {
                this.emojiSuggestionHelper = new EmojiSuggestionHelper((ChatScreen)this);
            }
            if (Services.CONFIG.showEmojiSelector()) {
                this.emojiSelectionGui = new EmojiSelectionGui((ChatScreen)this);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int j, float partialTick) {
        super.render(guiGraphics, x, j, partialTick);
        if (this.emojiSuggestionHelper != null) {
            this.emojiSuggestionHelper.render(guiGraphics);
        }
        if (this.emojiSelectionGui != null) {
            this.emojiSelectionGui.mouseMoved(x, j);
            this.emojiSelectionGui.render(guiGraphics);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers) && CommonClass.shouldKeyBeIgnored(keyCode)) {
            return true;
        }
        if (this.emojiSuggestionHelper != null && this.emojiSuggestionHelper.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.emojiSelectionGui != null && this.emojiSelectionGui.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double x, double y, double scrollDelta, double d) {
        return super.mouseScrolled(x, y, scrollDelta, d) && this.emojiSelectionGui != null && this.emojiSelectionGui.mouseScrolled(x, y, scrollDelta, d);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.emojiSelectionGui != null) {
            this.emojiSelectionGui.mouseClicked(x, y, button);
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean charTyped(char c, int i) {
        return super.charTyped(c, i) && this.emojiSelectionGui != null && this.emojiSelectionGui.charTyped(c, i);
    }
}

