/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.multiworld;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.isaiah.multiworld.MultiworldMod;
import me.isaiah.multiworld.command.DeleteCommand;
import me.isaiah.multiworld.command.TpCommand;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleCommand {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"multiworld");

    public static int broadcast_console(MinecraftServer mc, CommandSourceStack source, String message) throws CommandSyntaxException {
        if (null == message) {
            LOGGER.info("Multiworld Mod for Minecraft " + mc.getServerVersion());
            LOGGER.info("(Console Commands are experimental)");
            return 1;
        }
        String[] args = message.split(" ");
        if (args[0].equalsIgnoreCase("help")) {
            for (String s : MultiworldMod.COMMAND_HELP) {
                LOGGER.info(s);
            }
            return 1;
        }
        if (args[0].equalsIgnoreCase("delete")) {
            DeleteCommand.run(mc, source, args);
            return 1;
        }
        if (args[0].equalsIgnoreCase("tp")) {
            if (args.length <= 2) {
                LOGGER.info("Usage: /mw tp <world> <player>");
                return 0;
            }
            return TpCommand.run(mc, null, args);
        }
        if (args[0].equalsIgnoreCase("list")) {
            LOGGER.info("All Worlds:");
            mc.getAllLevels().forEach(world -> LOGGER.info("- " + world.dimension().location().toString()));
            return 1;
        }
        if (args[0].equalsIgnoreCase("version")) {
            LOGGER.info("Multiworld Mod version 1.10");
            return 1;
        }
        throw CommandSourceStack.ERROR_NOT_PLAYER.create();
    }
}

