/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.arsocultas.common.blockentity;

import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.mystchonky.arsocultas.common.blockentity.TickingBlockEntity;
import com.mystchonky.arsocultas.common.registrar.BlockEntityRegistrar;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AltarBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    private static final int COST = 5000;

    public AltarBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityRegistrar.ALTAR.get(), pos, blockState);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.getGameTime() % 300L != 0L) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos.above());
        if (blockEntity instanceof GoldenSacrificialBowlBlockEntity) {
            GoldenSacrificialBowlBlockEntity bowl = (GoldenSacrificialBowlBlockEntity)blockEntity;
            RecipeHolder recipe = bowl.getCurrentRitualRecipe();
            if (recipe == null || bowl.sacrificeFulfilled()) {
                return;
            }
            for (BlockPos b : BlockPos.withinManhattan((BlockPos)this.getBlockPos().above(3), (int)10, (int)10, (int)6)) {
                MobJarTile mobJarTile;
                BlockEntity blockEntity2 = level.getBlockEntity(b);
                if (!(blockEntity2 instanceof MobJarTile) || !((blockEntity2 = (mobJarTile = (MobJarTile)blockEntity2).getEntity()) instanceof LivingEntity)) continue;
                LivingEntity entity = (LivingEntity)blockEntity2;
                if (!((RitualRecipe)recipe.value()).getRitual().isValidSacrifice(entity)) continue;
                if (SourceUtil.hasSourceNearby((BlockPos)this.worldPosition, (Level)level, (int)10, (int)5000)) {
                    SourceUtil.takeSourceWithParticles((BlockPos)this.worldPosition, (Level)level, (int)10, (int)5000);
                    bowl.notifySacrifice(null);
                }
                return;
            }
        }
    }
}

