/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedavaritia.config;

import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import thelm.packagedavaritia.block.entity.EndCrafterBlockEntity;
import thelm.packagedavaritia.block.entity.ExtremeCrafterBlockEntity;
import thelm.packagedavaritia.block.entity.NetherCrafterBlockEntity;
import thelm.packagedavaritia.block.entity.SculkCrafterBlockEntity;

public class PackagedAvaritiaConfig {
    private static ModConfigSpec serverSpec;
    public static ModConfigSpec.IntValue sculkCrafterEnergyCapacity;
    public static ModConfigSpec.IntValue sculkCrafterEnergyReq;
    public static ModConfigSpec.IntValue sculkCrafterEnergyUsage;
    public static ModConfigSpec.BooleanValue sculkCrafterDrawMEEnergy;
    public static ModConfigSpec.IntValue netherCrafterEnergyCapacity;
    public static ModConfigSpec.IntValue netherCrafterEnergyReq;
    public static ModConfigSpec.IntValue netherCrafterEnergyUsage;
    public static ModConfigSpec.BooleanValue netherCrafterDrawMEEnergy;
    public static ModConfigSpec.IntValue endCrafterEnergyCapacity;
    public static ModConfigSpec.IntValue endCrafterEnergyReq;
    public static ModConfigSpec.IntValue endCrafterEnergyUsage;
    public static ModConfigSpec.BooleanValue endCrafterDrawMEEnergy;
    public static ModConfigSpec.IntValue extremeCrafterEnergyCapacity;
    public static ModConfigSpec.IntValue extremeCrafterEnergyReq;
    public static ModConfigSpec.IntValue extremeCrafterEnergyUsage;
    public static ModConfigSpec.BooleanValue extremeCrafterDrawMEEnergy;

    private PackagedAvaritiaConfig() {
    }

    public static void registerConfig(ModContainer modContainer) {
        PackagedAvaritiaConfig.buildConfig();
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
    }

    private static void buildConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("sculk_crafter");
        builder.comment("How much FE the Sculk Package Crafter should hold.");
        sculkCrafterEnergyCapacity = builder.defineInRange("energy_capacity", 5000, 0, Integer.MAX_VALUE);
        builder.comment("How much total FE the Sculk Package Crafter should use per operation.");
        sculkCrafterEnergyReq = builder.defineInRange("energy_req", 500, 0, Integer.MAX_VALUE);
        builder.comment("How much FE/t maximum the Sculk Package Crafter can use.");
        sculkCrafterEnergyUsage = builder.defineInRange("energy_usage", 100, 0, Integer.MAX_VALUE);
        builder.comment("Should the Sculk Package Crafter draw energy from ME systems.");
        sculkCrafterDrawMEEnergy = builder.define("draw_me_energy", true);
        builder.pop();
        builder.push("nether_crafter");
        builder.comment("How much FE the Nether Package Crafter should hold.");
        netherCrafterEnergyCapacity = builder.defineInRange("energy_capacity", 5000, 0, Integer.MAX_VALUE);
        builder.comment("How much total FE the Nether Package Crafter should use per operation.");
        netherCrafterEnergyReq = builder.defineInRange("energy_req", 1000, 0, Integer.MAX_VALUE);
        builder.comment("How much FE/t maximum the Nether Package Crafter can use.");
        netherCrafterEnergyUsage = builder.defineInRange("energy_usage", 125, 0, Integer.MAX_VALUE);
        builder.comment("Should the Nether Package Crafter draw energy from ME systems.");
        netherCrafterDrawMEEnergy = builder.define("draw_me_energy", true);
        builder.pop();
        builder.push("end_crafter");
        builder.comment("How much FE the End Package Crafter should hold.");
        endCrafterEnergyCapacity = builder.defineInRange("energy_capacity", 5000, 0, Integer.MAX_VALUE);
        builder.comment("How much total FE the End Package Crafter should use per operation.");
        endCrafterEnergyReq = builder.defineInRange("energy_req", 2500, 0, Integer.MAX_VALUE);
        builder.comment("How much FE/t maximum the End Package Crafter can use.");
        endCrafterEnergyUsage = builder.defineInRange("energy_usage", 250, 0, Integer.MAX_VALUE);
        builder.comment("Should the End Package Crafter draw energy from ME systems.");
        endCrafterDrawMEEnergy = builder.define("draw_me_energy", true);
        builder.pop();
        builder.push("extreme_crafter");
        builder.comment("How much FE the Extreme Package Crafter should hold.");
        extremeCrafterEnergyCapacity = builder.defineInRange("energy_capacity", 5000, 0, Integer.MAX_VALUE);
        builder.comment("How much total FE the Extreme Package Crafter should use per operation.");
        extremeCrafterEnergyReq = builder.defineInRange("energy_req", 5000, 0, Integer.MAX_VALUE);
        builder.comment("How much FE/t maximum the Extreme Package Crafter can use.");
        extremeCrafterEnergyUsage = builder.defineInRange("energy_usage", 500, 0, Integer.MAX_VALUE);
        builder.comment("Should the Extreme Package Crafter draw energy from ME systems.");
        extremeCrafterDrawMEEnergy = builder.define("draw_me_energy", true);
        builder.pop();
        serverSpec = builder.build();
    }

    public static void reloadServerConfig() {
        SculkCrafterBlockEntity.energyCapacity = (Integer)sculkCrafterEnergyCapacity.get();
        SculkCrafterBlockEntity.energyReq = (Integer)sculkCrafterEnergyReq.get();
        SculkCrafterBlockEntity.energyUsage = (Integer)sculkCrafterEnergyUsage.get();
        SculkCrafterBlockEntity.drawMEEnergy = (Boolean)sculkCrafterDrawMEEnergy.get();
        NetherCrafterBlockEntity.energyCapacity = (Integer)netherCrafterEnergyCapacity.get();
        NetherCrafterBlockEntity.energyReq = (Integer)netherCrafterEnergyReq.get();
        NetherCrafterBlockEntity.energyUsage = (Integer)netherCrafterEnergyUsage.get();
        NetherCrafterBlockEntity.drawMEEnergy = (Boolean)netherCrafterDrawMEEnergy.get();
        EndCrafterBlockEntity.energyCapacity = (Integer)endCrafterEnergyCapacity.get();
        EndCrafterBlockEntity.energyReq = (Integer)endCrafterEnergyReq.get();
        EndCrafterBlockEntity.energyUsage = (Integer)endCrafterEnergyUsage.get();
        EndCrafterBlockEntity.drawMEEnergy = (Boolean)endCrafterDrawMEEnergy.get();
        ExtremeCrafterBlockEntity.energyCapacity = (Integer)extremeCrafterEnergyCapacity.get();
        ExtremeCrafterBlockEntity.energyReq = (Integer)extremeCrafterEnergyReq.get();
        ExtremeCrafterBlockEntity.energyUsage = (Integer)extremeCrafterEnergyUsage.get();
        ExtremeCrafterBlockEntity.drawMEEnergy = (Boolean)extremeCrafterDrawMEEnergy.get();
    }
}

