/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedavaritia.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import committee.nova.mods.avaritia.api.common.crafting.ITierCraftingRecipe;
import committee.nova.mods.avaritia.api.common.crafting.TierInput;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;
import thelm.packagedavaritia.recipe.EndPackageRecipeType;
import thelm.packagedavaritia.recipe.ITablePackageRecipeInfo;

public class EndPackageRecipeInfo
implements ITablePackageRecipeInfo {
    public static final MapCodec<EndPackageRecipeInfo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(EndPackageRecipeInfo::getRecipeId), (App)Codec.INT.fieldOf("width").forGetter(EndPackageRecipeInfo::getMatrixWidth), (App)Codec.INT.fieldOf("height").forGetter(EndPackageRecipeInfo::getMatrixHeight), (App)ItemStack.OPTIONAL_CODEC.orElse((Object)ItemStack.EMPTY).sizeLimitedListOf(49).fieldOf("input").forGetter(EndPackageRecipeInfo::getMatrixAsList)).apply((Applicative)instance, EndPackageRecipeInfo::new));
    public static final Codec<EndPackageRecipeInfo> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, EndPackageRecipeInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, EndPackageRecipeInfo::getRecipeId, (StreamCodec)ByteBufCodecs.INT, EndPackageRecipeInfo::getMatrixWidth, (StreamCodec)ByteBufCodecs.INT, EndPackageRecipeInfo::getMatrixHeight, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, EndPackageRecipeInfo::getMatrixAsList, EndPackageRecipeInfo::new);
    private final ResourceLocation id;
    private final ITierCraftingRecipe recipe;
    private final List<ItemStack> input;
    private final TierInput matrix;
    private final ItemStack output;
    private final List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public EndPackageRecipeInfo(ResourceLocation id, int width, int height, List<ItemStack> matrixSer) {
        this.id = id;
        this.matrix = TierInput.of((int)width, (int)height, matrixSer, (int)3);
        this.input = MiscHelper.INSTANCE.condenseStacks(this.matrix.items());
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
        Recipe recipeSer = MiscHelper.INSTANCE.getRecipeManager().byKey(id).map(RecipeHolder::value).orElse(null);
        if (recipeSer instanceof ITierCraftingRecipe) {
            ITierCraftingRecipe tableRecipe;
            this.recipe = tableRecipe = (ITierCraftingRecipe)recipeSer;
            this.output = this.recipe.assemble((RecipeInput)this.matrix, (HolderLookup.Provider)MiscHelper.INSTANCE.getRegistryAccess()).copy();
        } else {
            this.recipe = null;
            this.output = ItemStack.EMPTY;
        }
    }

    public EndPackageRecipeInfo(List<ItemStack> inputs, Level level) {
        NonNullList matrixList = NonNullList.withSize((int)49, (Object)ItemStack.EMPTY);
        int[] slotArray = EndPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 49; ++i) {
            ItemStack toSet = inputs.get(slotArray[i]);
            toSet.setCount(1);
            matrixList.set(i, (Object)toSet.copy());
        }
        this.matrix = TierInput.of((int)7, (int)7, (List)matrixList, (int)3);
        RecipeHolder recipeHolder = MiscHelper.INSTANCE.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get(), (RecipeInput)this.matrix, level).orElse(null);
        if (recipeHolder != null) {
            this.id = recipeHolder.id();
            this.recipe = (ITierCraftingRecipe)recipeHolder.value();
            this.output = this.recipe.assemble((RecipeInput)this.matrix, (HolderLookup.Provider)level.registryAccess()).copy();
        } else {
            this.id = null;
            this.recipe = null;
            this.output = null;
        }
        this.input = MiscHelper.INSTANCE.condenseStacks(this.matrix.items());
        int i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public IPackageRecipeType getRecipeType() {
        return EndPackageRecipeType.INSTANCE;
    }

    @Override
    public int getTier() {
        return 3;
    }

    public boolean isValid() {
        return this.id != null && this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.copy();
    }

    @Override
    public ITierCraftingRecipe getRecipe() {
        return this.recipe;
    }

    public ResourceLocation getRecipeId() {
        return this.id;
    }

    @Override
    public TierInput getMatrix() {
        return this.matrix;
    }

    public List<ItemStack> getMatrixAsList() {
        return Collections.unmodifiableList(this.matrix.items());
    }

    public int getMatrixWidth() {
        return this.matrix.width();
    }

    public int getMatrixHeight() {
        return this.matrix.height();
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return this.recipe.getRemainingItems((RecipeInput)this.matrix);
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = EndPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < this.matrix.height(); ++i) {
            for (int j = 0; j < this.matrix.width(); ++j) {
                map.put(slotArray[i * 7 + j], (Object)this.matrix.getItem(i * this.matrix.width() + j));
            }
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EndPackageRecipeInfo) {
            EndPackageRecipeInfo other = (EndPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals((IPackageRecipeInfo)this, (Object)this.recipe, (IPackageRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode((IPackageRecipeInfo)this, (Object)this.recipe);
    }
}

