/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import org.jetbrains.annotations.Nullable;

public class FertilizedEssenceItem
extends BaseItem {
    public FertilizedEssenceItem() {
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new DispenserBehavior());
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        Level level = context.getLevel();
        if (FertilizedEssenceItem.applyFertilizer(stack, level, pos, player)) {
            if (!level.isClientSide()) {
                level.levelEvent(1505, pos, 0);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        int chance = (int)((Double)ModConfigs.FERTILIZED_ESSENCE_DROP_CHANCE.get() * 100.0);
        tooltip.add((Component)ModTooltips.FERTILIZED_ESSENCE_CHANCE.args(new Object[]{chance + "%"}).build());
    }

    public static boolean applyFertilizer(ItemStack stack, Level level, BlockPos pos, @Nullable Player player) {
        BonemealableBlock growable;
        BlockState state = level.getBlockState(pos);
        BonemealEvent event = EventHooks.fireBonemealEvent((Player)player, (Level)level, (BlockPos)pos, (BlockState)state, (ItemStack)stack);
        if (event.isCanceled()) {
            return event.isSuccessful();
        }
        Block block = state.getBlock();
        if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, state)) {
            if (!level.isClientSide()) {
                RandomSource random = level.getRandom();
                if (growable.isBonemealSuccess(level, random, pos, state) || FertilizedEssenceItem.canGrowResourceCrops(growable)) {
                    growable.performBonemeal((ServerLevel)level, random, pos, state);
                }
                stack.shrink(1);
            }
            return true;
        }
        return false;
    }

    private static boolean canGrowResourceCrops(BonemealableBlock growable) {
        ICropProvider cropGetter;
        return growable instanceof ICropProvider && (cropGetter = (ICropProvider)growable).getCrop().getTier().isFertilizable();
    }

    public static class DispenserBehavior
    extends OptionalDispenseItemBehavior {
        protected ItemStack execute(BlockSource source, ItemStack stack) {
            this.setSuccess(true);
            ServerLevel level = source.level();
            BlockPos pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
            if (FertilizedEssenceItem.applyFertilizer(stack, (Level)level, pos, null)) {
                if (!level.isClientSide()) {
                    level.levelEvent(2005, pos, 0);
                }
            } else {
                this.setSuccess(false);
            }
            return stack;
        }
    }
}

