/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.io.sentry;

import java.io.Closeable;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.polylib.io.sentry.AsyncHttpTransportFactory;
import net.creeperhost.polylib.io.sentry.Attachment;
import net.creeperhost.polylib.io.sentry.Breadcrumb;
import net.creeperhost.polylib.io.sentry.EventProcessor;
import net.creeperhost.polylib.io.sentry.ISentryClient;
import net.creeperhost.polylib.io.sentry.ISpan;
import net.creeperhost.polylib.io.sentry.ITransportFactory;
import net.creeperhost.polylib.io.sentry.NoOpTransportFactory;
import net.creeperhost.polylib.io.sentry.RequestDetailsResolver;
import net.creeperhost.polylib.io.sentry.Scope;
import net.creeperhost.polylib.io.sentry.SentryBaseEvent;
import net.creeperhost.polylib.io.sentry.SentryEnvelope;
import net.creeperhost.polylib.io.sentry.SentryEnvelopeHeader;
import net.creeperhost.polylib.io.sentry.SentryEnvelopeItem;
import net.creeperhost.polylib.io.sentry.SentryEvent;
import net.creeperhost.polylib.io.sentry.SentryLevel;
import net.creeperhost.polylib.io.sentry.SentryOptions;
import net.creeperhost.polylib.io.sentry.Session;
import net.creeperhost.polylib.io.sentry.TraceState;
import net.creeperhost.polylib.io.sentry.UserFeedback;
import net.creeperhost.polylib.io.sentry.hints.DiskFlushNotification;
import net.creeperhost.polylib.io.sentry.protocol.Contexts;
import net.creeperhost.polylib.io.sentry.protocol.SentryId;
import net.creeperhost.polylib.io.sentry.protocol.SentryTransaction;
import net.creeperhost.polylib.io.sentry.transport.ITransport;
import net.creeperhost.polylib.io.sentry.util.ApplyScopeUtils;
import net.creeperhost.polylib.io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SentryClient
implements ISentryClient {
    static final String SENTRY_PROTOCOL_VERSION = "7";
    private boolean enabled;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ITransport transport;
    @Nullable
    private final SecureRandom random;
    @NotNull
    private final SortBreadcrumbsByDate sortBreadcrumbsByDate = new SortBreadcrumbsByDate();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    SentryClient(@NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options, "SentryOptions is required.");
        this.enabled = true;
        ITransportFactory transportFactory = options.getTransportFactory();
        if (transportFactory instanceof NoOpTransportFactory) {
            transportFactory = new AsyncHttpTransportFactory();
            options.setTransportFactory(transportFactory);
        }
        RequestDetailsResolver requestDetailsResolver = new RequestDetailsResolver(options);
        this.transport = transportFactory.create(options, requestDetailsResolver.resolve());
        this.random = options.getSampleRate() == null ? null : new SecureRandom();
    }

    private boolean shouldApplyScopeData(@NotNull SentryBaseEvent event, @Nullable Object hint) {
        if (ApplyScopeUtils.shouldApplyScopeData(hint)) {
            return true;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Event was cached so not applying scope: %s", event.getEventId());
        return false;
    }

    @Override
    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent event, @Nullable Scope scope, @Nullable Object hint) {
        Objects.requireNonNull(event, "SentryEvent is required.");
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing event: %s", event.getEventId());
        if (this.shouldApplyScopeData(event, hint) && (event = this.applyScope(event, scope, hint)) == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by applyScope", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        event = this.processEvent(event, hint, this.options.getEventProcessors());
        Session session = null;
        if (event != null) {
            session = this.updateSessionData(event, hint, scope);
            if (!this.sample()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event %s was dropped due to sampling decision.", event.getEventId());
                event = null;
            }
        }
        if (event != null) {
            if (event.getThrowable() != null && this.options.containsIgnoredExceptionForType(event.getThrowable())) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped as the exception %s is ignored", event.getThrowable().getClass());
                return SentryId.EMPTY_ID;
            }
            if ((event = this.executeBeforeSend(event, hint)) == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by beforeSend", new Object[0]);
            }
        }
        SentryId sentryId = SentryId.EMPTY_ID;
        if (event != null && event.getEventId() != null) {
            sentryId = event.getEventId();
        }
        try {
            TraceState traceState = scope != null && scope.getTransaction() != null ? scope.getTransaction().traceState() : null;
            SentryEnvelope envelope = this.buildEnvelope(event, this.getAttachmentsFromScope(scope), session, traceState);
            if (envelope != null) {
                this.transport.send(envelope, hint);
            }
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, e, "Capturing event %s failed.", sentryId);
            sentryId = SentryId.EMPTY_ID;
        }
        return sentryId;
    }

    @Nullable
    private List<Attachment> getAttachmentsFromScope(@Nullable Scope scope) {
        if (scope != null) {
            return scope.getAttachments();
        }
        return null;
    }

    @Nullable
    private SentryEnvelope buildEnvelope(@Nullable SentryBaseEvent event, @Nullable List<Attachment> attachments, @Nullable Session session, @Nullable TraceState traceState) throws IOException {
        SentryId sentryId = null;
        ArrayList<SentryEnvelopeItem> envelopeItems = new ArrayList<SentryEnvelopeItem>();
        if (event != null) {
            SentryEnvelopeItem eventItem = SentryEnvelopeItem.fromEvent(this.options.getSerializer(), event);
            envelopeItems.add(eventItem);
            sentryId = event.getEventId();
        }
        if (session != null) {
            SentryEnvelopeItem sessionItem = SentryEnvelopeItem.fromSession(this.options.getSerializer(), session);
            envelopeItems.add(sessionItem);
        }
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                SentryEnvelopeItem attachmentItem = SentryEnvelopeItem.fromAttachment(attachment, this.options.getMaxAttachmentSize());
                envelopeItems.add(attachmentItem);
            }
        }
        if (!envelopeItems.isEmpty()) {
            SentryEnvelopeHeader envelopeHeader = new SentryEnvelopeHeader(sentryId, this.options.getSdkVersion(), traceState);
            return new SentryEnvelope(envelopeHeader, envelopeItems);
        }
        return null;
    }

    @Nullable
    private SentryEvent processEvent(@NotNull SentryEvent event, @Nullable Object hint, @NotNull List<EventProcessor> eventProcessors) {
        for (EventProcessor processor : eventProcessors) {
            try {
                event = processor.process(event, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, e, "An exception occurred while processing event by processor: %s", processor.getClass().getName());
            }
            if (event != null) continue;
            this.options.getLogger().log(SentryLevel.DEBUG, "Event was dropped by a processor: %s", processor.getClass().getName());
            break;
        }
        return event;
    }

    @Nullable
    private SentryTransaction processTransaction(@NotNull SentryTransaction transaction, @Nullable Object hint, @NotNull List<EventProcessor> eventProcessors) {
        for (EventProcessor processor : eventProcessors) {
            try {
                transaction = processor.process(transaction, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, e, "An exception occurred while processing transaction by processor: %s", processor.getClass().getName());
            }
            if (transaction != null) continue;
            this.options.getLogger().log(SentryLevel.DEBUG, "Transaction was dropped by a processor: %s", processor.getClass().getName());
            break;
        }
        return transaction;
    }

    @Override
    public void captureUserFeedback(@NotNull UserFeedback userFeedback) {
        Objects.requireNonNull(userFeedback, "SentryEvent is required.");
        if (SentryId.EMPTY_ID.equals(userFeedback.getEventId())) {
            this.options.getLogger().log(SentryLevel.WARNING, "Capturing userFeedback without a Sentry Id.", new Object[0]);
            return;
        }
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing userFeedback: %s", userFeedback.getEventId());
        try {
            SentryEnvelope envelope = this.buildEnvelope(userFeedback);
            this.transport.send(envelope);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, e, "Capturing user feedback %s failed.", userFeedback.getEventId());
        }
    }

    @NotNull
    private SentryEnvelope buildEnvelope(@NotNull UserFeedback userFeedback) {
        ArrayList<SentryEnvelopeItem> envelopeItems = new ArrayList<SentryEnvelopeItem>();
        SentryEnvelopeItem userFeedbackItem = SentryEnvelopeItem.fromUserFeedback(this.options.getSerializer(), userFeedback);
        envelopeItems.add(userFeedbackItem);
        SentryEnvelopeHeader envelopeHeader = new SentryEnvelopeHeader(userFeedback.getEventId(), this.options.getSdkVersion());
        return new SentryEnvelope(envelopeHeader, envelopeItems);
    }

    @TestOnly
    @Nullable
    Session updateSessionData(@NotNull SentryEvent event, @Nullable Object hint, @Nullable Scope scope) {
        Session clonedSession = null;
        if (ApplyScopeUtils.shouldApplyScopeData(hint)) {
            if (scope != null) {
                clonedSession = scope.withSession(session -> {
                    if (session != null) {
                        Session.State status = null;
                        if (event.isCrashed()) {
                            status = Session.State.Crashed;
                        }
                        boolean crashedOrErrored = false;
                        if (Session.State.Crashed == status || event.isErrored()) {
                            crashedOrErrored = true;
                        }
                        String userAgent = null;
                        if (event.getRequest() != null && event.getRequest().getHeaders() != null && event.getRequest().getHeaders().containsKey("user-agent")) {
                            userAgent = event.getRequest().getHeaders().get("user-agent");
                        }
                        if (session.update(status, userAgent, crashedOrErrored) && hint instanceof DiskFlushNotification) {
                            session.end();
                        }
                    } else {
                        this.options.getLogger().log(SentryLevel.INFO, "Session is null on scope.withSession", new Object[0]);
                    }
                });
            } else {
                this.options.getLogger().log(SentryLevel.INFO, "Scope is null on client.captureEvent", new Object[0]);
            }
        }
        return clonedSession;
    }

    @Override
    @ApiStatus.Internal
    public void captureSession(@NotNull Session session, @Nullable Object hint) {
        SentryEnvelope envelope;
        Objects.requireNonNull(session, "Session is required.");
        if (session.getRelease() == null || session.getRelease().isEmpty()) {
            this.options.getLogger().log(SentryLevel.WARNING, "Sessions can't be captured without setting a release.", new Object[0]);
            return;
        }
        try {
            envelope = SentryEnvelope.from(this.options.getSerializer(), session, this.options.getSdkVersion());
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture session.", e);
            return;
        }
        this.captureEnvelope(envelope, hint);
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public SentryId captureEnvelope(@NotNull SentryEnvelope envelope, @Nullable Object hint) {
        Objects.requireNonNull(envelope, "SentryEnvelope is required.");
        try {
            this.transport.send(envelope, hint);
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture envelope.", e);
            return SentryId.EMPTY_ID;
        }
        SentryId eventId = envelope.getHeader().getEventId();
        if (eventId != null) {
            return eventId;
        }
        return SentryId.EMPTY_ID;
    }

    @Override
    @NotNull
    public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceState traceState, @Nullable Scope scope, @Nullable Object hint) {
        Objects.requireNonNull(transaction, "Transaction is required.");
        this.options.getLogger().log(SentryLevel.DEBUG, "Capturing transaction: %s", transaction.getEventId());
        SentryId sentryId = SentryId.EMPTY_ID;
        if (transaction.getEventId() != null) {
            sentryId = transaction.getEventId();
        }
        if (this.shouldApplyScopeData(transaction, hint)) {
            if ((transaction = this.applyScope(transaction, scope)) != null && scope != null) {
                transaction = this.processTransaction(transaction, hint, scope.getEventProcessors());
            }
            if (transaction == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction was dropped by applyScope", new Object[0]);
            }
        }
        if (transaction != null) {
            transaction = this.processTransaction(transaction, hint, this.options.getEventProcessors());
        }
        if (transaction == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Transaction was dropped by Event processors.", new Object[0]);
            return SentryId.EMPTY_ID;
        }
        try {
            SentryEnvelope envelope = this.buildEnvelope(transaction, this.filterForTransaction(this.getAttachmentsFromScope(scope)), null, traceState);
            if (envelope != null) {
                this.transport.send(envelope, hint);
            } else {
                sentryId = SentryId.EMPTY_ID;
            }
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, e, "Capturing transaction %s failed.", sentryId);
            sentryId = SentryId.EMPTY_ID;
        }
        return sentryId;
    }

    @Nullable
    private List<Attachment> filterForTransaction(@Nullable List<Attachment> attachments) {
        if (attachments == null) {
            return null;
        }
        ArrayList<Attachment> attachmentsToSend = new ArrayList<Attachment>();
        for (Attachment attachment : attachments) {
            if (!attachment.isAddToTransactions()) continue;
            attachmentsToSend.add(attachment);
        }
        return attachmentsToSend;
    }

    @Nullable
    private SentryEvent applyScope(@NotNull SentryEvent event, @Nullable Scope scope, @Nullable Object hint) {
        if (scope != null) {
            this.applyScope(event, scope);
            if (event.getTransaction() == null) {
                event.setTransaction(scope.getTransactionName());
            }
            if (event.getFingerprints() == null) {
                event.setFingerprints(scope.getFingerprint());
            }
            if (scope.getLevel() != null) {
                event.setLevel(scope.getLevel());
            }
            ISpan span = scope.getSpan();
            if (event.getContexts().getTrace() == null && span != null) {
                event.getContexts().setTrace(span.getSpanContext());
            }
            event = this.processEvent(event, hint, scope.getEventProcessors());
        }
        return event;
    }

    @NotNull
    private <T extends SentryBaseEvent> T applyScope(@NotNull T sentryBaseEvent, @Nullable Scope scope) {
        if (scope != null) {
            if (sentryBaseEvent.getRequest() == null) {
                sentryBaseEvent.setRequest(scope.getRequest());
            }
            if (sentryBaseEvent.getUser() == null) {
                sentryBaseEvent.setUser(scope.getUser());
            }
            if (sentryBaseEvent.getTags() == null) {
                sentryBaseEvent.setTags(new HashMap<String, String>(scope.getTags()));
            } else {
                for (Map.Entry<String, String> entry : scope.getTags().entrySet()) {
                    if (sentryBaseEvent.getTags().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getTags().put(entry.getKey(), entry.getValue());
                }
            }
            if (sentryBaseEvent.getBreadcrumbs() == null) {
                sentryBaseEvent.setBreadcrumbs(new ArrayList<Breadcrumb>(scope.getBreadcrumbs()));
            } else {
                this.sortBreadcrumbsByDate(sentryBaseEvent, scope.getBreadcrumbs());
            }
            if (sentryBaseEvent.getExtras() == null) {
                sentryBaseEvent.setExtras(new HashMap<String, Object>(scope.getExtras()));
            } else {
                for (Map.Entry<String, Object> entry : scope.getExtras().entrySet()) {
                    if (sentryBaseEvent.getExtras().containsKey(entry.getKey())) continue;
                    sentryBaseEvent.getExtras().put(entry.getKey(), entry.getValue());
                }
            }
            Contexts contexts = sentryBaseEvent.getContexts();
            for (Map.Entry entry : new Contexts(scope.getContexts()).entrySet()) {
                if (contexts.containsKey(entry.getKey())) continue;
                contexts.put((String)entry.getKey(), entry.getValue());
            }
        }
        return sentryBaseEvent;
    }

    private void sortBreadcrumbsByDate(@NotNull SentryBaseEvent event, @NotNull Collection<Breadcrumb> breadcrumbs) {
        List<Breadcrumb> sortedBreadcrumbs = event.getBreadcrumbs();
        if (sortedBreadcrumbs != null && !breadcrumbs.isEmpty()) {
            sortedBreadcrumbs.addAll(breadcrumbs);
            Collections.sort(sortedBreadcrumbs, this.sortBreadcrumbsByDate);
        }
    }

    @Nullable
    private SentryEvent executeBeforeSend(@NotNull SentryEvent event, @Nullable Object hint) {
        SentryOptions.BeforeSendCallback beforeSend = this.options.getBeforeSend();
        if (beforeSend != null) {
            try {
                event = beforeSend.execute(event, hint);
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "The BeforeSend callback threw an exception. It will be added as breadcrumb and continue.", e);
                Breadcrumb breadcrumb = new Breadcrumb();
                breadcrumb.setMessage("BeforeSend callback failed.");
                breadcrumb.setCategory("SentryClient");
                breadcrumb.setLevel(SentryLevel.ERROR);
                if (e.getMessage() != null) {
                    breadcrumb.setData("sentry:message", e.getMessage());
                }
                event.addBreadcrumb(breadcrumb);
            }
        }
        return event;
    }

    @Override
    public void close() {
        this.options.getLogger().log(SentryLevel.INFO, "Closing SentryClient.", new Object[0]);
        try {
            this.flush(this.options.getShutdownTimeout());
            this.transport.close();
        }
        catch (IOException e) {
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the connection to the Sentry Server.", e);
        }
        for (EventProcessor eventProcessor : this.options.getEventProcessors()) {
            if (!(eventProcessor instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)eventProcessor)).close();
            }
            catch (IOException e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to close the event processor {}.", eventProcessor, e);
            }
        }
        this.enabled = false;
    }

    @Override
    public void flush(long timeoutMillis) {
        this.transport.flush(timeoutMillis);
    }

    private boolean sample() {
        if (this.options.getSampleRate() != null && this.random != null) {
            double sampling = this.options.getSampleRate();
            return !(sampling < this.random.nextDouble());
        }
        return true;
    }

    private static final class SortBreadcrumbsByDate
    implements Comparator<Breadcrumb> {
        private SortBreadcrumbsByDate() {
        }

        @Override
        public int compare(@NotNull Breadcrumb b1, @NotNull Breadcrumb b2) {
            return b1.getTimestamp().compareTo(b2.getTimestamp());
        }
    }
}

