/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.mulitblock;

import java.util.HashMap;
import java.util.Set;
import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.mulitblock.IMultiblockPart;
import net.creeperhost.polylib.mulitblock.MultiblockControllerBase;
import net.creeperhost.polylib.mulitblock.MultiblockWorldRegistry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class MultiblockRegistry {
    private static HashMap<Level, MultiblockWorldRegistry> registries = new HashMap();

    public static void tickStart(Level world) {
        if (registries.containsKey(world)) {
            MultiblockWorldRegistry registry = registries.get(world);
            registry.processMultiblockChanges();
            registry.tickStart();
        }
    }

    public static void onChunkLoaded(Level world, LevelChunk chunk) {
        if (registries.containsKey(world)) {
            registries.get(world).onChunkLoaded(chunk);
        }
    }

    public static void onPartAdded(Level world, IMultiblockPart part) {
        MultiblockWorldRegistry registry = MultiblockRegistry.getOrCreateRegistry(world);
        registry.onPartAdded(part);
    }

    public static void onPartRemovedFromWorld(Level world, IMultiblockPart part) {
        if (registries.containsKey(world)) {
            registries.get(world).onPartRemovedFromWorld(part);
        }
    }

    public static void onWorldUnloaded(Level world) {
        if (registries.containsKey(world)) {
            registries.get(world).onWorldUnloaded();
            registries.remove(world);
        }
    }

    public static void addDirtyController(Level world, MultiblockControllerBase controller) {
        if (registries.containsKey(world)) {
            registries.get(world).addDirtyController(controller);
        }
    }

    public static void addDeadController(Level world, MultiblockControllerBase controller) {
        if (registries.containsKey(world)) {
            registries.get(world).addDeadController(controller);
        } else {
            PolyLib.LOGGER.warn(String.format("Controller %d in world %s marked as dead, but that world is not tracked! Controller is being ignored.", controller.hashCode(), world));
        }
    }

    public static Set<MultiblockControllerBase> getControllersFromWorld(Level world) {
        if (registries.containsKey(world)) {
            return registries.get(world).getControllers();
        }
        return null;
    }

    private static MultiblockWorldRegistry getOrCreateRegistry(Level world) {
        if (registries.containsKey(world)) {
            return registries.get(world);
        }
        MultiblockWorldRegistry newRegistry = new MultiblockWorldRegistry(world);
        registries.put(world, newRegistry);
        return newRegistry;
    }
}

