/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.platform.services;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import tfar.craftingstation.blockentity.CraftingStationBlockEntity;
import tfar.craftingstation.menu.CraftingStationMenu;
import tfar.craftingstation.network.C2SModPacket;
import tfar.craftingstation.network.S2CModPacket;
import tfar.craftingstation.platform.MLConfig;
import tfar.craftingstation.util.SideContainerWrapper;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public <MSG extends S2CModPacket> void registerClientPacket(CustomPacketPayload.Type<MSG> var1, StreamCodec<RegistryFriendlyByteBuf, MSG> var2);

    public <MSG extends C2SModPacket> void registerServerPacket(CustomPacketPayload.Type<MSG> var1, StreamCodec<RegistryFriendlyByteBuf, MSG> var2);

    public void sendToClient(CustomPacketPayload var1, ServerPlayer var2);

    public void sendToServer(CustomPacketPayload var1);

    public void forgeHooks$setCraftingPlayer(Player var1);

    public void forgeEventFactory$firePlayerCraftingEvent(Player var1, ItemStack var2, CraftingContainer var3);

    public boolean hasCapability(BlockEntity var1);

    public MLConfig getConfig();

    public void openMenu(ServerPlayer var1, MenuProvider var2, BlockPos var3);

    public MenuType<CraftingStationMenu> customMenu();

    public SideContainerWrapper getWrapper(BlockEntity var1);

    default public CraftingStationBlockEntity create(BlockPos pos, BlockState state) {
        return new CraftingStationBlockEntity(pos, state);
    }
}

