/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis;

import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.AdventureEvents;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.affix.trades.AffixTrade;
import dev.shadowsoffire.apotheosis.affix.trades.AutomaticAffixTrade;
import dev.shadowsoffire.apotheosis.compat.PatchouliCompat;
import dev.shadowsoffire.apotheosis.compat.curios.CuriosCompat;
import dev.shadowsoffire.apotheosis.compat.gateways.GatewaysCompat;
import dev.shadowsoffire.apotheosis.compat.twilight.AdventureTwilightCompat;
import dev.shadowsoffire.apotheosis.data.AffixLootEntryProvider;
import dev.shadowsoffire.apotheosis.data.AffixProvider;
import dev.shadowsoffire.apotheosis.data.ApothAdvancementProvider;
import dev.shadowsoffire.apotheosis.data.ApothDataMapProvider;
import dev.shadowsoffire.apotheosis.data.ApothLootProvider;
import dev.shadowsoffire.apotheosis.data.ApothPaintingTagsProvider;
import dev.shadowsoffire.apotheosis.data.ApothPaintingsProvider;
import dev.shadowsoffire.apotheosis.data.ApothRecipeProvider;
import dev.shadowsoffire.apotheosis.data.AugmentationProvider;
import dev.shadowsoffire.apotheosis.data.EliteProvider;
import dev.shadowsoffire.apotheosis.data.GLMProvider;
import dev.shadowsoffire.apotheosis.data.GearSetProvider;
import dev.shadowsoffire.apotheosis.data.GemProvider;
import dev.shadowsoffire.apotheosis.data.InvaderProvider;
import dev.shadowsoffire.apotheosis.data.PurityWeightsProvider;
import dev.shadowsoffire.apotheosis.data.RarityOverrideProvider;
import dev.shadowsoffire.apotheosis.data.RarityProvider;
import dev.shadowsoffire.apotheosis.data.RogueSpawnerProvider;
import dev.shadowsoffire.apotheosis.data.SongProvider;
import dev.shadowsoffire.apotheosis.data.TierAugmentProvider;
import dev.shadowsoffire.apotheosis.data.WandererTradesProvider;
import dev.shadowsoffire.apotheosis.data.gateways.ApothGateProvider;
import dev.shadowsoffire.apotheosis.data.twilight.TwilightAffixLootProvider;
import dev.shadowsoffire.apotheosis.data.twilight.TwilightGearSetProvider;
import dev.shadowsoffire.apotheosis.data.twilight.TwilightInvaderProvider;
import dev.shadowsoffire.apotheosis.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.loot.LootRule;
import dev.shadowsoffire.apotheosis.loot.RarityOverrideRegistry;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.mobs.ApothMobEvents;
import dev.shadowsoffire.apotheosis.mobs.registries.AugmentRegistry;
import dev.shadowsoffire.apotheosis.mobs.registries.EliteRegistry;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.mobs.util.EntityModifier;
import dev.shadowsoffire.apotheosis.mobs.util.SpawnCondition;
import dev.shadowsoffire.apotheosis.net.BossSpawnPayload;
import dev.shadowsoffire.apotheosis.net.LinkItemToChatPayload;
import dev.shadowsoffire.apotheosis.net.RadialStatePayload;
import dev.shadowsoffire.apotheosis.net.RerollResultPayload;
import dev.shadowsoffire.apotheosis.net.WorldTierPayload;
import dev.shadowsoffire.apotheosis.socket.gem.ExtraGemBonusRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.PurityWeightsRegistry;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.spawner.RogueSpawnerRegistry;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.apotheosis.tiers.augments.TierAugmentRegistry;
import dev.shadowsoffire.apotheosis.util.NameHelper;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.datagen.DataGenBuilder;
import dev.shadowsoffire.placebo.network.PayloadHelper;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import dev.shadowsoffire.placebo.systems.wanderer.WandererTradesRegistry;
import dev.shadowsoffire.placebo.tabs.TabFillingRegistry;
import dev.shadowsoffire.placebo.util.RunnableReloader;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="apotheosis")
public class Apotheosis {
    public static final String MODID = "apotheosis";
    public static final Logger LOGGER = LogManager.getLogger((String)"apotheosis");
    public static final boolean DEBUG_WORLDGEN = "on".equalsIgnoreCase(System.getenv("APOTH_DEBUG_WORLDGEN"));
    public static final boolean DEBUG_MOBS = "on".equalsIgnoreCase(System.getenv("APOTH_DEBUG_MOBS"));
    public static final boolean STAGES_LOADED = ModList.get().isLoaded("gamestages");

    public Apotheosis(IEventBus bus) {
        Apoth.bootstrap(bus);
        bus.register((Object)this);
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.ARMOR.value()), (Object)200.0, (String)"maxValue");
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.ARMOR_TOUGHNESS.value()), (Object)100.0, (String)"maxValue");
        LootRule.initCodecs();
        SpawnCondition.initCodecs();
        EntityModifier.initCodecs();
        GemBonus.initCodecs();
        if (ModList.get().isLoaded("gateways")) {
            GatewaysCompat.register(bus);
        }
        if (ModList.get().isLoaded("twilightforest")) {
            AdventureTwilightCompat.register();
        }
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.register();
        }
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.register(bus);
        }
        WandererTradesRegistry.INSTANCE.registerCodec(Apotheosis.loc("affix_trade"), AffixTrade.CODEC);
        WandererTradesRegistry.INSTANCE.registerCodec(Apotheosis.loc("automatic_affix_trade"), AutomaticAffixTrade.CODEC);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            TabFillingRegistry.register((ResourceKey)Apoth.Tabs.ADVENTURE.getKey(), (Holder[])new Holder[]{Apoth.Items.COMMON_MATERIAL, Apoth.Items.UNCOMMON_MATERIAL, Apoth.Items.RARE_MATERIAL, Apoth.Items.EPIC_MATERIAL, Apoth.Items.MYTHIC_MATERIAL, Apoth.Items.GEM_DUST, Apoth.Items.GEM_FUSED_SLATE, Apoth.Items.SIGIL_OF_SOCKETING, Apoth.Items.SIGIL_OF_WITHDRAWAL, Apoth.Items.SIGIL_OF_REBIRTH, Apoth.Items.SIGIL_OF_ENHANCEMENT, Apoth.Items.SIGIL_OF_UNNAMING, Apoth.Items.SIGIL_OF_MALICE, Apoth.Items.SIGIL_OF_SUPREMACY, Apoth.Items.SALVAGING_TABLE, Apoth.Items.GEM_CUTTING_TABLE, Apoth.Items.SIMPLE_REFORGING_TABLE, Apoth.Items.REFORGING_TABLE, Apoth.Items.AUGMENTING_TABLE, Apoth.Items.IRON_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.GOLD_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.DIAMOND_UPGRADE_SMITHING_TEMPLATE, Apoth.Items.MUSIC_DISC_FLASH, Apoth.Items.MUSIC_DISC_GLIMMER, Apoth.Items.MUSIC_DISC_SHIMMER, Apoth.Items.GEM, Apoth.Items.BOSS_SUMMONER});
            TabFillingRegistry.register((ResourceKey)CreativeModeTabs.FOOD_AND_DRINKS, (Holder[])new Holder[]{Apoth.Items.POTION_CHARM});
        });
        PayloadHelper.registerPayload((PayloadProvider)new BossSpawnPayload.Provider());
        PayloadHelper.registerPayload((PayloadProvider)new RerollResultPayload.Provider());
        PayloadHelper.registerPayload((PayloadProvider)new RadialStatePayload.Provider());
        PayloadHelper.registerPayload((PayloadProvider)new WorldTierPayload.Provider());
        PayloadHelper.registerPayload((PayloadProvider)new AdventureConfig.ConfigPayload.Provider());
        PayloadHelper.registerPayload((PayloadProvider)new LinkItemToChatPayload.Provider());
        NeoForge.EVENT_BUS.register((Object)new AdventureEvents());
        NeoForge.EVENT_BUS.register((Object)new ApothMobEvents());
        RarityRegistry.INSTANCE.registerToBus();
        RarityOverrideRegistry.INSTANCE.registerToBus();
        AffixRegistry.INSTANCE.registerToBus();
        ExtraGemBonusRegistry.INSTANCE.registerToBus();
        GemRegistry.INSTANCE.registerToBus();
        AffixLootRegistry.INSTANCE.registerToBus();
        InvaderRegistry.INSTANCE.registerToBus();
        RogueSpawnerRegistry.INSTANCE.registerToBus();
        EliteRegistry.INSTANCE.registerToBus();
        PurityWeightsRegistry.INSTANCE.registerToBus();
        AugmentRegistry.INSTANCE.registerToBus();
        TierAugmentRegistry.INSTANCE.registerToBus();
        Apotheosis.loadConfig(true);
        NeoForge.EVENT_BUS.addListener(AddReloadListenerEvent.class, event -> event.addListener((PreparableReloadListener)RunnableReloader.of(() -> Apotheosis.loadConfig(false))));
    }

    @SubscribeEvent
    public void caps(RegisterCapabilitiesEvent e) {
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Apoth.Tiles.SALVAGING_TABLE, (be, side) -> be.getItemHandler());
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Apoth.Tiles.REFORGING_TABLE, (be, side) -> be.getInventory());
    }

    @SubscribeEvent
    public void data(GatherDataEvent e) {
        DataProvider.INDENT_WIDTH.set(4);
        DataGenBuilder.create((String[])new String[]{MODID}).registry(Registries.JUKEBOX_SONG, SongProvider::bootstrap).registry(Registries.PAINTING_VARIANT, ApothPaintingsProvider::bootstrap).provider(ApothLootProvider::create).provider(ApothRecipeProvider::new).provider(ApothPaintingTagsProvider::new).provider(RarityProvider::new).provider(RarityOverrideProvider::new).provider(AffixLootEntryProvider::new).provider(AffixProvider::new).provider(GemProvider::new).provider(GLMProvider::new).provider(GearSetProvider::new).provider(PurityWeightsProvider::new).provider(InvaderProvider::new).provider(EliteProvider::new).provider(ApothAdvancementProvider::create).provider(TierAugmentProvider::new).provider(RogueSpawnerProvider::new).provider(WandererTradesProvider::new).provider(TwilightAffixLootProvider::new).provider(TwilightGearSetProvider::new).provider(TwilightInvaderProvider::new).provider(ApothDataMapProvider::new).provider(AugmentationProvider::new).provider(ApothGateProvider::new).build(e);
        Object2IntOpenHashMap map = (Object2IntOpenHashMap)DataProvider.FIXED_ORDER_FIELDS;
        for (Purity purity : Purity.values()) {
            map.put((Object)purity.getSerializedName(), purity.ordinal() + 1);
        }
        for (Enum enum_ : WorldTier.values()) {
            map.put((Object)((WorldTier)enum_).getSerializedName(), enum_.ordinal() + 1);
        }
        map.put((Object)"min", 1);
        map.put((Object)"max", 2);
        map.put((Object)"apotheosis:common", 1);
        map.put((Object)"apotheosis:uncommon", 2);
        map.put((Object)"apotheosis:rare", 3);
        map.put((Object)"apotheosis:epic", 4);
        map.put((Object)"apotheosis:mythic", 5);
        map.put((Object)"duration", 1);
        map.put((Object)"bonuses", 5);
        Gateways.setupDatagenFieldOrder();
    }

    public static void loadConfig(boolean firstLoad) {
        Configuration mainConfig = new Configuration(ApothicAttributes.getConfigFile((String)MODID));
        Configuration nameConfig = new Configuration(ApothicAttributes.getConfigFile((String)"name_generation"));
        AdventureConfig.load(mainConfig);
        NameHelper.load(nameConfig);
        if (firstLoad && mainConfig.hasChanged()) {
            mainConfig.save();
        }
        if (firstLoad && nameConfig.hasChanged()) {
            nameConfig.save();
        }
    }

    public static ResourceLocation loc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static MutableComponent lang(String type, String path, Object ... args) {
        return Component.translatable((String)Apotheosis.langKey(type, path), (Object[])args);
    }

    public static String langKey(String type, String path) {
        return type + ".apotheosis." + path;
    }

    public static MutableComponent sysMessageHeader() {
        return Component.translatable((String)"[%s] ", (Object[])new Object[]{Component.literal((String)"Apoth").withStyle(ChatFormatting.GOLD)});
    }

    public static void debugLog(BlockPos pos, String name) {
        if (DEBUG_WORLDGEN) {
            LOGGER.info("Generated a {} at {} {} {}", (Object)name, (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
        }
    }
}

