/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import dev.shadowsoffire.apotheosis.particle.RarityParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.Mth;

public class RarityParticle
extends TextureSheetParticle {
    public RarityParticle(RarityParticleData data, ClientLevel level, double x, double y, double z, double velX, double velY, double velZ) {
        super(level, x, y, z, velX, velY, velZ);
        this.rCol = data.red();
        this.gCol = data.green();
        this.bCol = data.blue();
        this.lifetime = 80;
        this.xd = velX;
        this.yd = velY;
        this.zd = velZ;
        this.speedUpWhenYMotionIsBlocked = true;
        this.friction = 1.0f;
        this.quadSize = 0.05f + 0.03f * (float)level.random.nextGaussian();
    }

    protected int getLightColor(float partialTicks) {
        return LightTexture.pack((int)15, (int)15);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public float getQuadSize(float p_217561_1_) {
        return 0.75f * this.quadSize * Mth.clamp((float)(((float)this.age + p_217561_1_) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        super.tick();
        this.alpha = 0.75f * (1.0f - (float)this.age / (float)this.lifetime);
    }
}

