/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.compat.gateways;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.mobs.registries.InvaderRegistry;
import dev.shadowsoffire.apotheosis.mobs.types.Invader;
import dev.shadowsoffire.apotheosis.tiers.GenContext;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public record InvaderWaveEntity(DynamicHolder<Invader> invader, int count, Optional<String> desc) implements WaveEntity
{
    public static Codec<InvaderWaveEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)InvaderRegistry.INSTANCE.holderCodec().optionalFieldOf("invader", (Object)InvaderRegistry.INSTANCE.emptyHolder()).forGetter(InvaderWaveEntity::invader), (App)Codec.intRange((int)1, (int)256).optionalFieldOf("count", (Object)1).forGetter(InvaderWaveEntity::count), (App)Codec.STRING.optionalFieldOf("desc").forGetter(InvaderWaveEntity::desc)).apply((Applicative)inst, InvaderWaveEntity::new));

    public LivingEntity createEntity(ServerLevel level, GatewayEntity gate) {
        GenContext ctx = GenContext.forPlayer(gate.summonerOrClosest());
        Invader realBoss = this.resolveInvader(ctx);
        if (realBoss == null) {
            if (this.usingRandomInvader()) {
                Apotheosis.LOGGER.error("Failed to resolve a random invader when generating an InvaderWaveEntity!");
            } else {
                String type = this.invader.getId().toString();
                Apotheosis.LOGGER.error("Failed to resolve the invader '{}' when generating an InvaderWaveEntity!", (Object)type);
            }
            return null;
        }
        return realBoss.createBoss((ServerLevelAccessor)level, BlockPos.ZERO, ctx);
    }

    public MutableComponent getDescription() {
        MutableComponent desc = Apotheosis.lang("wave_entity", "invader", Component.translatable((String)this.desc.orElse(InvaderWaveEntity.resolveInvaderDesc(this.invader))));
        return Gateways.lang((String)"tooltip", (String)"with_count", (Object[])new Object[]{this.getCount(), desc});
    }

    public boolean shouldFinalizeSpawn() {
        return false;
    }

    public Codec<? extends WaveEntity> getCodec() {
        return CODEC;
    }

    public int getCount() {
        return this.count;
    }

    protected boolean usingRandomInvader() {
        return this.invader.equals((Object)InvaderRegistry.INSTANCE.emptyHolder());
    }

    @Nullable
    protected Invader resolveInvader(GenContext ctx) {
        if (this.usingRandomInvader()) {
            return InvaderRegistry.INSTANCE.getRandomItem(ctx);
        }
        return this.invader().getOptional().orElse(null);
    }

    public static InvaderWaveEntity create(DynamicHolder<Invader> invader, int count, @Nullable String desc) {
        return new InvaderWaveEntity(invader, count, Optional.ofNullable(desc));
    }

    public static InvaderWaveEntity createRandom(int count) {
        return new InvaderWaveEntity((DynamicHolder<Invader>)InvaderRegistry.INSTANCE.emptyHolder(), count, Optional.empty());
    }

    private static String resolveInvaderDesc(DynamicHolder<Invader> invader) {
        return invader.isBound() ? ((Invader)invader.get()).entity().getDescriptionId() : "misc.apotheosis.random";
    }
}

