/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.mobs.util.SurfaceType;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import java.util.Map;
import java.util.Optional;

public record InvaderSpawnRules(Map<WorldTier, Float> spawnChances, Optional<Integer> cooldown, SurfaceType surfaceType) {
    public static final Codec<InvaderSpawnRules> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WorldTier.mapCodec(Codec.floatRange((float)0.0f, (float)1.0f)).fieldOf("spawn_chances").forGetter(InvaderSpawnRules::spawnChances), (App)Codec.intRange((int)0, (int)720000).optionalFieldOf("cooldown").forGetter(InvaderSpawnRules::cooldown), (App)SurfaceType.CODEC.fieldOf("surface_type").forGetter(InvaderSpawnRules::surfaceType)).apply((Applicative)inst, InvaderSpawnRules::new)).validate(InvaderSpawnRules::validate);

    private static DataResult<InvaderSpawnRules> validate(InvaderSpawnRules rules) {
        if (rules.spawnChances.size() == WorldTier.values().length) {
            return DataResult.success((Object)rules);
        }
        StringBuilder sb = new StringBuilder("Missing Spawn Chances for the following world tiers: ");
        for (WorldTier tier : WorldTier.values()) {
            if (rules.spawnChances.containsKey((Object)tier)) continue;
            sb.append(tier.getSerializedName()).append(" ");
        }
        return DataResult.error(() -> sb.toString());
    }
}

