/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mobs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.mobs.util.SurfaceType;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ServerLevelAccessor;

public interface SpawnCondition
extends CodecProvider<SpawnCondition> {
    public static final CodecMap<SpawnCondition> CODEC = new CodecMap("Apothic Spawn Conditions");

    public boolean test(Mob var1, ServerLevelAccessor var2, MobSpawnType var3, @Nullable CompoundTag var4);

    default public boolean requiresNbtAccess() {
        return false;
    }

    public static boolean checkAll(List<SpawnCondition> conditions, Mob mob, ServerLevelAccessor level, MobSpawnType type) {
        if (conditions.isEmpty()) {
            return true;
        }
        boolean requiresNbt = false;
        for (SpawnCondition ex : conditions) {
            requiresNbt |= ex.requiresNbtAccess();
        }
        CompoundTag nbt = requiresNbt ? mob.saveWithoutId(new CompoundTag()) : null;
        boolean success = true;
        for (SpawnCondition ex : conditions) {
            success &= ex.test(mob, level, type, nbt);
        }
        return success;
    }

    public static void initCodecs() {
        SpawnCondition.register("spawn_type", SpawnTypeCondition.CODEC);
        SpawnCondition.register("surface_type", SurfaceTypeCondition.CODEC);
        SpawnCondition.register("has_tag", EntityTagCondition.CODEC);
        SpawnCondition.register("is_monster", IsMonsterCondition.CODEC);
        SpawnCondition.register("nbt", NbtCondition.CODEC);
        SpawnCondition.register("and", AndCondition.CODEC);
        SpawnCondition.register("or", OrCondition.CODEC);
        SpawnCondition.register("not", NotCondition.CODEC);
        SpawnCondition.register("xor", XorCondition.CODEC);
    }

    private static void register(String id, Codec<? extends SpawnCondition> codec) {
        CODEC.register(Apotheosis.loc(id), codec);
    }

    public record SpawnTypeCondition(Set<MobSpawnType> types) implements SpawnCondition
    {
        public static Codec<SpawnTypeCondition> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.setOf((Codec)PlaceboCodecs.enumCodec(MobSpawnType.class)).fieldOf("spawn_types").forGetter(SpawnTypeCondition::types)).apply((Applicative)inst, SpawnTypeCondition::new));

        public Codec<? extends SpawnCondition> getCodec() {
            return CODEC;
        }

        @Override
        public boolean test(Mob mob, ServerLevelAccessor level, MobSpawnType spawnType, CompoundTag entityNbt) {
            return this.types.contains(spawnType);
        }

        public static SpawnTypeCondition of(MobSpawnType ... types) {
            return new SpawnTypeCondition(new LinkedHashSet<MobSpawnType>(Arrays.asList(types)));
        }
    }

    public record SurfaceTypeCondition(SurfaceType type) implements SpawnCondition
    {
        public static Codec<SurfaceTypeCondition> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SurfaceType.CODEC.fieldOf("surface_type").forGetter(SurfaceTypeCondition::type)).apply((Applicative)inst, SurfaceTypeCondition::new));

        public Codec<? extends SpawnCondition> getCodec() {
            return CODEC;
        }

        @Override
        public boolean test(Mob mob, ServerLevelAccessor level, MobSpawnType spawnType, CompoundTag entityNbt) {
            return this.type.test(level, mob.blockPosition());
        }
    }

    public record EntityTagCondition(TagKey<EntityType<?>> tag) implements SpawnCondition
    {
        public static Codec<EntityTagCondition> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TagKey.codec((ResourceKey)Registries.ENTITY_TYPE).fieldOf("tag").forGetter(EntityTagCondition::tag)).apply((Applicative)inst, EntityTagCondition::new));

        public Codec<? extends SpawnCondition> getCodec() {
            return CODEC;
        }

        @Override
        public boolean test(Mob mob, ServerLevelAccessor level, MobSpawnType spawnType, CompoundTag entityNbt) {
            return mob.getType().is(this.tag);
        }
    }

    public record IsMonsterCondition() implements SpawnCondition
    {
        public static Codec<IsMonsterCondition> CODEC = Codec.unit(IsMonsterCondition::new);

        public Codec<? extends SpawnCondition> getCodec() {
            return CODEC;
        }

        @Override
        public boolean test(Mob mob, ServerLevelAccessor level, MobSpawnType spawnType, CompoundTag entityNbt) {
            return mob instanceof Monster;
        }
    }

    public record NbtCondition(CompoundTag nbt) implements SpawnCondition
    {
        public static Codec<NbtCondition> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)NBTAdapter.EITHER_CODEC.fieldOf("nbt").forGetter(NbtCondition::nbt)).apply((Applicative)inst, NbtCondition::new));

        public Codec<? extends SpawnCondition> getCodec() {
            return CODEC;
        }

        @Override
        public boolean test(Mob mob, ServerLevelAccessor level, MobSpawnType spawnType, CompoundTag entityNbt) {
            return NbtUtils.compareNbt((Tag)this.nbt, (Tag)entityNbt, (boolean)true);
        }

        @Override
        public boolean requiresNbtAccess() {
            return true;
        }
    }

    public record AndCondition(List<SpawnCondition> spawnConditions) implements SpawnCondition
    {
        public static Codec<AndCondition> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.listOf().fieldOf("spawn_conditions").forGetter(AndCondition::spawnConditions)).apply((Applicative)inst, AndCondition::new));

        public Codec<? extends SpawnCondition> getCodec() {
            return CODEC;
        }

        @Override
        public boolean test(Mob mob, ServerLevelAccessor level, MobSpawnType type, CompoundTag nbt) {
            boolean success = true;
            for (SpawnCondition cond : this.spawnConditions) {
                success &= cond.test(mob, level, type, nbt);
            }
            return success;
        }

        @Override
        public boolean requiresNbtAccess() {
            boolean requiresNbt = false;
            for (SpawnCondition ex : this.spawnConditions) {
                requiresNbt |= ex.requiresNbtAccess();
            }
            return requiresNbt;
        }
    }

    public record OrCondition(List<SpawnCondition> spawnConditions) implements SpawnCondition
    {
        public static Codec<OrCondition> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.listOf().fieldOf("spawn_conditions").forGetter(OrCondition::spawnConditions)).apply((Applicative)inst, OrCondition::new));

        public Codec<? extends SpawnCondition> getCodec() {
            return CODEC;
        }

        @Override
        public boolean test(Mob mob, ServerLevelAccessor level, MobSpawnType type, CompoundTag nbt) {
            for (SpawnCondition ex : this.spawnConditions) {
                if (!ex.test(mob, level, type, nbt)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean requiresNbtAccess() {
            boolean requiresNbt = false;
            for (SpawnCondition ex : this.spawnConditions) {
                requiresNbt |= ex.requiresNbtAccess();
            }
            return requiresNbt;
        }
    }

    public record NotCondition(SpawnCondition spawnCondition) implements SpawnCondition
    {
        public static Codec<NotCondition> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("spawn_condition").forGetter(NotCondition::spawnCondition)).apply((Applicative)inst, NotCondition::new));

        public Codec<? extends SpawnCondition> getCodec() {
            return CODEC;
        }

        @Override
        public boolean test(Mob mob, ServerLevelAccessor level, MobSpawnType type, CompoundTag nbt) {
            return !this.spawnCondition.test(mob, level, type, nbt);
        }

        @Override
        public boolean requiresNbtAccess() {
            return this.spawnCondition.requiresNbtAccess();
        }
    }

    public record XorCondition(SpawnCondition left, SpawnCondition right) implements SpawnCondition
    {
        public static Codec<XorCondition> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("left").forGetter(XorCondition::left), (App)CODEC.fieldOf("right").forGetter(XorCondition::right)).apply((Applicative)inst, XorCondition::new));

        public Codec<? extends SpawnCondition> getCodec() {
            return CODEC;
        }

        @Override
        public boolean test(Mob mob, ServerLevelAccessor level, MobSpawnType type, CompoundTag nbt) {
            return this.left.test(mob, level, type, nbt) ^ this.right.test(mob, level, type, nbt);
        }

        @Override
        public boolean requiresNbtAccess() {
            return this.left.requiresNbtAccess() || this.right.requiresNbtAccess();
        }
    }
}

