/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.recipe;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.socket.ReactiveSmithingRecipe;
import dev.shadowsoffire.apotheosis.util.ApothSmithingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SupremacyRecipe
extends ApothSmithingRecipe
implements ReactiveSmithingRecipe {
    public SupremacyRecipe() {
        super(Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Apoth.Items.SIGIL_OF_SUPREMACY.value()}), ItemStack.EMPTY);
    }

    public boolean matches(SmithingRecipeInput inv, Level level) {
        ItemStack base = inv.getItem(1);
        ItemStack sigils = inv.getItem(2);
        return base.getCount() == 1 && sigils.is(Apoth.Items.SIGIL_OF_SUPREMACY) && AffixHelper.hasAffixes(base);
    }

    public ItemStack assemble(SmithingRecipeInput inv, HolderLookup.Provider regs) {
        ItemStack out = inv.getItem(1).copy();
        AffixHelper.applySupremacy(out);
        return out;
    }

    @Override
    public void onCraft(Container inv, Player player, ItemStack output) {
        player.playSound((SoundEvent)Apoth.Sounds.MALICE.value(), 1.0f, player.getRandom().nextFloat() * 0.4f + 0.8f);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Apoth.RecipeSerializers.SUPREMACY.value();
    }

    public RecipeType<?> getType() {
        return RecipeType.SMITHING;
    }

    public boolean isSpecial() {
        return true;
    }
}

