/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.socket.gem.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.effect.DamageReductionAffix;
import dev.shadowsoffire.apotheosis.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.socket.gem.GemView;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.bonus.GemBonus;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class DamageReductionBonus
extends GemBonus {
    protected final DamageReductionAffix.DamageType type;
    protected final Map<Purity, Float> values;
    public static Codec<DamageReductionBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(DamageReductionBonus.gemClass(), (App)DamageReductionAffix.DamageType.CODEC.fieldOf("damage_type").forGetter(a -> a.type), (App)Purity.mapCodec(Codec.floatRange((float)0.0f, (float)1.0f)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, DamageReductionBonus::new));

    public DamageReductionBonus(GemClass gemClass, DamageReductionAffix.DamageType type, Map<Purity, Float> values) {
        super(gemClass);
        this.type = type;
        this.values = values;
    }

    @Override
    public Component getSocketBonusTooltip(GemView gem, AttributeTooltipContext ctx) {
        float level = this.values.get(gem.purity()).floatValue();
        return Component.translatable((String)"affix.apotheosis:damage_reduction.desc", (Object[])new Object[]{Component.translatable((String)("misc.apotheosis." + this.type.getSerializedName())), Affix.fmt(100.0f * level)}).withStyle(ChatFormatting.YELLOW);
    }

    @Override
    public float onHurt(GemInstance gem, DamageSource src, LivingEntity user, float amount) {
        if (!src.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !src.is(DamageTypeTags.BYPASSES_ENCHANTMENTS) && this.type.test(src)) {
            float level = this.values.get(gem.purity()).floatValue();
            return amount * (1.0f - level);
        }
        return super.onHurt(gem, src, user, amount);
    }

    @Override
    public boolean supports(Purity purity) {
        return this.values.containsKey(purity);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends GemBonus.Builder {
        private DamageReductionAffix.DamageType type;
        private Map<Purity, Float> values = new HashMap<Purity, Float>();

        public Builder damageType(DamageReductionAffix.DamageType type) {
            this.type = type;
            return this;
        }

        public Builder value(Purity purity, float value) {
            if (value < 0.0f || value > 1.0f) {
                throw new IllegalArgumentException("Value must be between 0 and 1");
            }
            this.values.put(purity, Float.valueOf(value));
            return this;
        }

        @Override
        public DamageReductionBonus build(GemClass gemClass) {
            return new DamageReductionBonus(gemClass, this.type, this.values);
        }
    }
}

