/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.util.Serializer;

public abstract class TraitEffect {
    public static final Codec<TraitEffect> DISPATCH_CODEC = SgRegistries.TRAIT_EFFECT_TYPE.byNameCodec().dispatch(TraitEffect::type, Serializer::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, TraitEffect> STREAM_CODEC = StreamCodec.of((buf, effect) -> {
        buf.writeResourceLocation(Objects.requireNonNull(SgRegistries.TRAIT_EFFECT_TYPE.getKey(effect.type())));
        effect.type().rawStreamCodec().encode(buf, effect);
    }, buf -> {
        TraitEffectType type = (TraitEffectType)SgRegistries.TRAIT_EFFECT_TYPE.get(buf.readResourceLocation());
        return (TraitEffect)Objects.requireNonNull(type).streamCodec().decode(buf);
    });

    public abstract TraitEffectType<?> type();

    public abstract Collection<String> getExtraWikiLines();

    public double onCalculateSynergy(double synergy, int traitLevel) {
        return synergy;
    }

    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        return baseValue;
    }

    public float onEntityIncomingDamage(ItemStack armor, int traitLevel, LivingEntity target, DamageSource source, float amount, float originalAmount) {
        return amount;
    }

    public int onDurabilityDamage(TraitActionContext context, int damageTaken) {
        return damageTaken;
    }

    public void onGearCrafted(TraitActionContext context) {
    }

    public void onRecalculatePre(ItemStack gear, int traitLevel) {
    }

    public void onRecalculatePost(ItemStack gear, int traitLevel) {
    }

    public Collection<GearPropertyValue<?>> getBonusProperties(int traitLevel, @Nullable Player player, GearProperty<?, ?> property, GearPropertyValue<?> baseValue, float damageRatio) {
        return Collections.emptyList();
    }

    public void onGetAttributeModifiers(TraitActionContext context, ItemAttributeModifiers.Builder builder) {
    }

    public InteractionResult onItemUse(UseOnContext context, int traitLevel) {
        return InteractionResult.PASS;
    }

    public void onItemSwing(ItemStack stack, LivingEntity wielder, int traitLevel) {
    }

    public float getMiningSpeedModifier(int traitLevel, BlockState state) {
        return 0.0f;
    }

    public void onUpdate(TraitActionContext context, boolean isEquipped) {
    }

    public ItemStack addLootDrops(TraitActionContext context, ItemStack stack) {
        return ItemStack.EMPTY;
    }
}

