/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class SgContainerBlockEntity
extends BaseContainerBlockEntity {
    protected final ItemStackHandler items;

    protected SgContainerBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.items = this.createItemHandler();
    }

    protected SgContainerBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, Supplier<ItemStackHandler> itemHandlerFactory) {
        super(pType, pPos, pBlockState);
        this.items = itemHandlerFactory.get();
    }

    public abstract ItemStackHandler createItemHandler();

    public IItemHandler getItemHandler() {
        return this.items;
    }

    @Deprecated
    protected NonNullList<ItemStack> getItems() {
        NonNullList result = NonNullList.withSize((int)this.items.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.items.getSlots(); ++i) {
            result.set(i, (Object)this.items.getStackInSlot(i));
        }
        return result;
    }

    @Deprecated
    protected void setItems(NonNullList<ItemStack> pItems) {
        for (int i = 0; i < this.items.getSlots() && i < pItems.size(); ++i) {
            this.items.setStackInSlot(i, (ItemStack)pItems.get(i));
        }
    }

    public void clearContent() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            this.items.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public ItemStack getItem(int pSlot) {
        return this.items.getStackInSlot(pSlot);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        ItemStack itemstack = this.items.getStackInSlot(pSlot);
        boolean flag = !pStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)pStack);
        this.items.setStackInSlot(pSlot, pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
        if (pSlot < this.getContainerSize() - 1 && !flag) {
            this.setChanged();
        }
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        if (pSlot >= 0 && pSlot < this.items.getSlots() && !this.items.getStackInSlot(pSlot).isEmpty() && pAmount > 0) {
            ItemStack stackInSlot = this.items.getStackInSlot(pSlot);
            this.items.setStackInSlot(pSlot, stackInSlot.copyWithCount(stackInSlot.getCount() - pAmount));
            return stackInSlot.copyWithCount(pAmount);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        if (pSlot >= 0 && pSlot < this.items.getSlots()) {
            ItemStack stack = this.items.getStackInSlot(pSlot);
            this.items.setStackInSlot(pSlot, ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public int getContainerSize() {
        return this.items.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean canPlaceItem(int pSlot, ItemStack pStack) {
        return this.items.isItemValid(pSlot, pStack);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.deserializeNBT(registries, tag.getCompound("items"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("items", (Tag)this.items.serializeNBT(registries));
    }
}

