/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.gear.MaterialModifiers;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;

public record GradeMaterialModifier(MaterialGrade grade) implements IMaterialModifier
{
    public static final MapCodec<GradeMaterialModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MaterialGrade.CODEC.fieldOf("grade").forGetter(m -> m.grade)).apply((Applicative)instance, GradeMaterialModifier::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GradeMaterialModifier> STREAM_CODEC = StreamCodec.composite(MaterialGrade.STREAM_CODEC, m -> m.grade, GradeMaterialModifier::new);

    @Override
    public IMaterialModifierType<?> getType() {
        return (IMaterialModifierType)MaterialModifiers.GRADE.get();
    }

    @Override
    public <T, V extends GearPropertyValue<T>> Collection<V> modifyStats(MaterialInstance material, PartType partType, PropertyKey<T, V> key, Collection<V> statMods) {
        if (key.property().isAffectedByGrades() && this.grade != null && key.property() instanceof NumberProperty) {
            float bonus = (float)this.grade.bonusPercent / 100.0f;
            ArrayList<NumberPropertyValue> ret = new ArrayList<NumberPropertyValue>();
            for (GearPropertyValue mod : statMods) {
                NumberPropertyValue numberValue = (NumberPropertyValue)mod;
                float value = ((Float)numberValue.value()).floatValue();
                ret.add(new NumberPropertyValue(value + Math.abs(value) * bonus, numberValue.operation()));
            }
            return ret;
        }
        return statMods;
    }

    @Override
    public void appendTooltip(List<Component> tooltip) {
        MutableComponent text = TextUtil.withColor(this.grade.getDisplayName(), Color.DEEPSKYBLUE);
        tooltip.add((Component)Component.translatable((String)"part.silentgear.gradeOnPart", (Object[])new Object[]{text}));
    }

    @Override
    public MutableComponent modifyMaterialName(MutableComponent name) {
        if (this.grade != MaterialGrade.NONE) {
            return name.append((Component)TextUtil.translate("misc", "spaceBrackets", this.grade.getDisplayName()));
        }
        return name;
    }

    public static class Type
    implements IMaterialModifierType<GradeMaterialModifier> {
        @Override
        public ResourceLocation getId() {
            return Const.GRADE;
        }

        @Override
        public Optional<GradeMaterialModifier> readModifier(ItemStack stack) {
            MaterialGrade grade = (MaterialGrade)((Object)stack.get(SgDataComponents.MATERIAL_GRADE));
            if (grade != null) {
                return Optional.of(new GradeMaterialModifier(grade));
            }
            return Optional.empty();
        }

        @Override
        public void addModifier(GradeMaterialModifier mod, ItemStack stack) {
            stack.set(SgDataComponents.MATERIAL_GRADE, (Object)mod.grade);
        }

        @Override
        public void removeModifier(ItemStack stack) {
            stack.remove(SgDataComponents.MATERIAL_GRADE);
        }

        @Override
        public MapCodec<GradeMaterialModifier> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, GradeMaterialModifier> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

