/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;

public final class BonusDropsTraitEffect
extends TraitEffect {
    public static final MapCodec<BonusDropsTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("base_chance").forGetter(t -> Float.valueOf(t.baseChance)), (App)Codec.FLOAT.fieldOf("bonus_multiplier").forGetter(t -> Float.valueOf(t.bonusMultiplier)), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(t -> t.ingredient), (App)Codec.STRING.optionalFieldOf("matched_items_text_for_wiki", (Object)"some items").forGetter(t -> t.matchedItemsText)).apply((Applicative)instance, BonusDropsTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BonusDropsTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.baseChance), (StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.bonusMultiplier), (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, e -> e.ingredient, (baseChance, bonusMultiplier, ingredient) -> new BonusDropsTraitEffect(baseChance.floatValue(), bonusMultiplier.floatValue(), (Ingredient)ingredient, "some items"));
    private final float baseChance;
    private final float bonusMultiplier;
    private final Ingredient ingredient;
    private final String matchedItemsText;

    public BonusDropsTraitEffect(float baseChance, float bonusMultiplier, Ingredient ingredient, String matchedItemsText) {
        this.baseChance = baseChance;
        this.bonusMultiplier = bonusMultiplier;
        this.ingredient = ingredient;
        this.matchedItemsText = matchedItemsText;
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.BONUS_DROPS.get();
    }

    @Override
    public ItemStack addLootDrops(TraitActionContext context, ItemStack stack) {
        if (this.ingredient.test(stack) && SilentGear.RANDOM.nextFloat() < this.baseChance * (float)context.traitLevel()) {
            ItemStack copy = stack.copy();
            copy.setCount(Math.round((float)stack.getCount() * this.bonusMultiplier));
            return copy;
        }
        return super.addLootDrops(context, stack);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(String.format("  - %d%% chance per level of dropping %d%% more of %s", (int)(100.0f * this.baseChance), (int)(100.0f * this.bonusMultiplier), this.matchedItemsText));
        return ret;
    }
}

