/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ISlingshotAmmo;
import net.silentchaos512.gear.item.SlingshotAmmoItem;
import net.silentchaos512.gear.item.gear.GearBowItem;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearData;

public class GearSlingshotItem
extends GearBowItem {
    private static final float POWER_SCALE = 0.35f;

    public GearSlingshotItem(Supplier<GearType> gearType) {
        super(gearType);
    }

    @Override
    public float getArrowVelocity(ItemStack stack, int charge) {
        return super.getArrowVelocity(stack, charge);
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> stack.getItem() instanceof ISlingshotAmmo;
    }

    @Override
    protected Projectile createProjectile(Level pLevel, LivingEntity pShooter, ItemStack pWeapon, ItemStack pAmmo, boolean pIsCrit) {
        SlingshotAmmoItem slingshotAmmoItem;
        Item item = pAmmo.getItem();
        SlingshotAmmoItem item2 = item instanceof SlingshotAmmoItem ? (slingshotAmmoItem = (SlingshotAmmoItem)item) : (SlingshotAmmoItem)SgItems.PEBBLE.get();
        AbstractArrow projectile = item2.createArrow(pLevel, pAmmo, pShooter, pWeapon);
        if (pIsCrit) {
            projectile.setCritArrow(true);
            float rangedDamage = GearData.getProperties(pWeapon).getNumber(GearProperties.RANGED_DAMAGE);
            projectile.setBaseDamage(projectile.getBaseDamage() - 1.0 + (double)rangedDamage);
        }
        return this.customArrow(projectile, pAmmo, pWeapon);
    }
}

