/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import javax.annotation.Nonnull;
import mob_grinding_utils.inventory.client.GuiMGUButton;
import mob_grinding_utils.inventory.client.MGUScreen;
import mob_grinding_utils.inventory.server.ContainerMGUSpawner;
import mob_grinding_utils.network.BEGuiClick;
import mob_grinding_utils.tile.TileEntityMGUSpawner;
import mob_grinding_utils.util.RL;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiMGUSpawner
extends MGUScreen<ContainerMGUSpawner> {
    protected final ContainerMGUSpawner container;
    private final TileEntityMGUSpawner tile;

    public GuiMGUSpawner(ContainerMGUSpawner container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, RL.mgu("textures/gui/entity_spawner_gui.png"));
        this.container = container;
        this.tile = this.container.tile;
        this.imageHeight = 226;
        this.imageWidth = 176;
    }

    public void init() {
        super.init();
        this.clearWidgets();
        Button.OnPress message = button -> {
            if (button instanceof GuiMGUButton) {
                PacketDistributor.sendToServer((CustomPacketPayload)new BEGuiClick(this.tile.getBlockPos(), ((GuiMGUButton)button).id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        };
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 101, this.topPos + 113, GuiMGUButton.Size.LARGE, 0, (Component)Component.empty(), button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new BEGuiClick(this.tile.getBlockPos(), 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.tile.showRenderBox = !this.tile.showRenderBox;
        }));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 101, this.topPos + 25, GuiMGUButton.Size.SMALL, 1, (Component)Component.literal((String)"-"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 153, this.topPos + 25, GuiMGUButton.Size.SMALL, 2, (Component)Component.literal((String)"+"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 101, this.topPos + 59, GuiMGUButton.Size.SMALL, 3, (Component)Component.literal((String)"-"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 153, this.topPos + 59, GuiMGUButton.Size.SMALL, 4, (Component)Component.literal((String)"+"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 101, this.topPos + 93, GuiMGUButton.Size.SMALL, 5, (Component)Component.literal((String)"-"), message));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 153, this.topPos + 93, GuiMGUButton.Size.SMALL, 6, (Component)Component.literal((String)"+"), message));
    }

    @Override
    protected void renderLabels(@Nonnull GuiGraphics gg, int mouseX, int mouseY) {
        gg.drawString(this.font, this.title, 8, this.imageHeight - 220, 0x404040, false);
        gg.drawString(this.font, (Component)Component.translatable((String)"block.mob_grinding_utils.absorption_hopper_d_u"), 102, 14, 0x404040, false);
        gg.drawString(this.font, (Component)Component.translatable((String)"block.mob_grinding_utils.absorption_hopper_n_s"), 102, 48, 0x404040, false);
        gg.drawString(this.font, (Component)Component.translatable((String)"block.mob_grinding_utils.absorption_hopper_w_e"), 102, 82, 0x404040, false);
        gg.drawCenteredString(this.font, !this.tile.showRenderBox ? "Show Area" : "Hide Area", 135, 117, 0xE0E0E0);
        if (this.tile.getProgress() > 0) {
            gg.drawCenteredString(this.font, "Attempting Spawn", 52, 98, 0x404040);
        }
        gg.drawCenteredString(this.font, String.valueOf(this.tile.getoffsetY()), 135, 29, 5285857);
        gg.drawCenteredString(this.font, String.valueOf(this.tile.getoffsetZ()), 135, 63, 5285857);
        gg.drawCenteredString(this.font, String.valueOf(this.tile.getoffsetX()), 135, 97, 5285857);
    }

    @Override
    protected void renderBg(@Nonnull GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(gg, partialTicks, mouseX, mouseY);
        gg.blit(this.TEX, this.leftPos + 44, this.topPos + 71 - this.tile.getProgressScaled(28), 178, 28 - this.tile.getProgressScaled(28), 16, 28);
    }
}

