/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidIngredient
implements ICustomIngredient {
    public static final MapCodec<FluidIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidValue.CODEC.fieldOf("value").forGetter($ -> $.value), (App)Codec.BOOL.fieldOf("advanced").forGetter($ -> $.advanced)).apply((Applicative)instance, FluidIngredient::new));
    private final Boolean advanced;
    private final List<Fluid> matchingFluids = new ArrayList<Fluid>();
    private Stream<ItemStack> bucketCache = null;
    private IntList matchingStacksPacked;
    public final FluidValue value;

    private List<Fluid> getMatchingFluids() {
        if (!this.matchingFluids.isEmpty()) {
            return this.matchingFluids;
        }
        FluidValue fluidValue = this.value;
        if (fluidValue instanceof FluidTagValue) {
            FluidTagValue fluidTagValue = (FluidTagValue)fluidValue;
            BuiltInRegistries.FLUID.getTagOrEmpty(fluidTagValue.tag).forEach(fluid -> this.matchingFluids.add((Fluid)fluid.value()));
        }
        return this.matchingFluids;
    }

    public FluidIngredient(TagKey<Fluid> tagIn, int amount, boolean advancedIn) {
        this.advanced = advancedIn;
        this.value = new FluidTagValue(tagIn, amount);
    }

    public FluidIngredient(TagKey<Fluid> tagIn) {
        this(tagIn, 1000, false);
    }

    public FluidIngredient(Fluid fluidIn, int amount, boolean advancedIn) {
        this.value = new SpecificFluidValue(new FluidStack(fluidIn, amount));
        this.advanced = advancedIn;
        this.matchingFluids.add(fluidIn);
    }

    public FluidIngredient(Fluid fluidIn) {
        this(fluidIn, 1000, false);
    }

    public FluidIngredient(FluidValue value, boolean advancedIn) {
        this.value = value;
        this.advanced = advancedIn;
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)MobGrindingUtils.FLUID_INGREDIENT.get();
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Optional<IFluidHandlerItem> cap = Optional.ofNullable((IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM));
        if (cap.isPresent()) {
            if (!this.advanced.booleanValue() && !(stack.getItem() instanceof BucketItem)) {
                return false;
            }
            FluidStack fluid = cap.get().getFluidInTank(0);
            return this.getMatchingFluids().contains(fluid.getFluid()) && fluid.getAmount() >= this.value.getAmount();
        }
        return false;
    }

    public Stream<ItemStack> getItems() {
        if (this.bucketCache == null) {
            ArrayList tmp = new ArrayList();
            this.getMatchingFluids().forEach(fluid -> {
                ItemStack newBucket = FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
                if (!newBucket.isEmpty()) {
                    tmp.add(newBucket);
                }
            });
            this.bucketCache = tmp.stream();
        }
        return this.bucketCache;
    }

    public static interface FluidValue {
        public static final Codec<FluidValue> CODEC = Codec.xor(SpecificFluidValue.CODEC, FluidTagValue.CODEC).xmap($ -> (FluidValue)$.map(value1 -> value1, value2 -> value2), fluidValue -> {
            if (fluidValue instanceof FluidTagValue) {
                FluidTagValue fluidTagValue = (FluidTagValue)fluidValue;
                return Either.right((Object)fluidTagValue);
            }
            if (fluidValue instanceof SpecificFluidValue) {
                SpecificFluidValue specificFluidValue = (SpecificFluidValue)fluidValue;
                return Either.left((Object)specificFluidValue);
            }
            throw new UnsupportedOperationException("This is neither a fluid nor a fluid tag.");
        });

        public int getAmount();

        public Collection<FluidStack> getFluids();
    }

    public record FluidTagValue(TagKey<Fluid> tag, int amount) implements FluidValue
    {
        public static final Codec<FluidTagValue> CODEC = RecordCodecBuilder.create(p_300962_ -> p_300962_.group((App)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("Tag").forGetter(p_300964_ -> p_300964_.tag), (App)Codec.INT.fieldOf("Amount").forGetter(p_300966_ -> p_300966_.amount)).apply((Applicative)p_300962_, FluidTagValue::new));

        @Override
        public int getAmount() {
            return this.amount;
        }

        @Override
        public Collection<FluidStack> getFluids() {
            ArrayList<FluidStack> list = new ArrayList<FluidStack>();
            for (Holder holder : BuiltInRegistries.FLUID.getTagOrEmpty(this.tag)) {
                list.add(new FluidStack((Fluid)holder.value(), 1000));
            }
            if (list.isEmpty()) {
                list.add(FluidStack.EMPTY);
            }
            return list;
        }
    }

    public record SpecificFluidValue(FluidStack fluidStack) implements FluidValue
    {
        public static final Codec<SpecificFluidValue> CODEC = RecordCodecBuilder.create(p_300958_ -> p_300958_.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(p_300960_ -> p_300960_.fluidStack)).apply((Applicative)p_300958_, SpecificFluidValue::new));

        @Override
        public int getAmount() {
            return this.fluidStack.getAmount();
        }

        @Override
        public Collection<FluidStack> getFluids() {
            return Collections.singleton(this.fluidStack);
        }
    }
}

