/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct.magnet_card;

import appeng.api.config.IncludeExclude;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.upgrades.Upgrades;
import com.google.common.collect.Maps;
import de.mari_023.ae2wtlib.AE2wtlibAdditionalComponents;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.api.AE2wtlibComponents;
import de.mari_023.ae2wtlib.api.AE2wtlibTags;
import de.mari_023.ae2wtlib.networking.RestockAmountPacket;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMode;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class MagnetHandler {
    private static final WeakHashMap<ServerPlayer, Integer> players = new WeakHashMap();

    public static void handle(ServerPlayer player, ItemStack terminal) {
        if (players.containsKey(player) && players.get(player) == MagnetHandler.getTick(player)) {
            return;
        }
        MagnetHandler.sendRestockAble(player, terminal);
        MagnetHandler.handleMagnet((Player)player, terminal);
        players.put(player, MagnetHandler.getTick(player));
    }

    private static int getTick(ServerPlayer player) {
        if (player.getServer() == null) {
            return -1;
        }
        return player.getServer().getTickCount();
    }

    private static void sendRestockAble(ServerPlayer player, ItemStack terminal) {
        if (player.isCreative()) {
            return;
        }
        if (!((Boolean)terminal.getOrDefault(AE2wtlibComponents.RESTOCK, (Object)false)).booleanValue()) {
            return;
        }
        MagnetHandler.sendRestockAble(player);
    }

    private static void sendRestockAble(ServerPlayer player) {
        CraftingTerminalHandler handler = CraftingTerminalHandler.getCraftingTerminalHandler((Player)player);
        ItemStack hostItem = handler.getCraftingTerminal();
        if (!((Boolean)hostItem.getOrDefault(AE2wtlibComponents.RESTOCK, (Object)false)).booleanValue() || !handler.inRange()) {
            return;
        }
        HashMap<Item, Long> items = new HashMap<Item, Long>();
        if (handler.getTargetGrid() == null) {
            return;
        }
        KeyCounter storageList = handler.getTargetGrid().getStorageService().getCachedInventory();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || items.containsKey(stack.getItem()) || stack.is(AE2wtlibTags.NO_RESTOCK)) continue;
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            if (key == null) {
                items.put(stack.getItem(), 0L);
                continue;
            }
            items.put(stack.getItem(), storageList.get((AEKey)key));
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)items.size());
        items.forEach((item, count) -> map.put(item.builtInRegistryHolder(), count));
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RestockAmountPacket(map), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void handleMagnet(Player player, ItemStack terminal) {
        if (player.isShiftKeyDown()) {
            return;
        }
        if (!MagnetHandler.getMagnetMode(terminal).magnet()) {
            return;
        }
        MagnetHandler.handleMagnet(player);
    }

    private static void handleMagnet(Player player) {
        CraftingTerminalHandler ctHandler = CraftingTerminalHandler.getCraftingTerminalHandler(player);
        if (!MagnetHandler.getMagnetMode(ctHandler.getCraftingTerminal()).magnet()) {
            return;
        }
        MagnetHost magnetHost = ctHandler.getMagnetHost();
        if (magnetHost == null) {
            return;
        }
        if (magnetHost.getPickupFilter().isEmpty() && magnetHost.getPickupMode() == IncludeExclude.WHITELIST) {
            return;
        }
        List entityItems = player.level().getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(AE2wtlibConfig.CONFIG.magnetCardRange()), EntitySelector.ENTITY_STILL_ALIVE);
        for (ItemEntity entityItemNearby : entityItems) {
            AEItemKey item = AEItemKey.of((ItemStack)entityItemNearby.getItem());
            if (item == null || !magnetHost.getPickupFilter().matchesFilter((AEKey)item, magnetHost.getPickupMode()) || entityItemNearby.getPersistentData().contains("PreventRemoteMovement")) continue;
            entityItemNearby.playerTouch(player);
        }
    }

    public static void saveMagnetMode(ItemStack terminal, MagnetMode magnetSettings) {
        if (magnetSettings == MagnetMode.INVALID || magnetSettings == MagnetMode.NO_CARD) {
            return;
        }
        Item item = terminal.getItem();
        if (!(item instanceof IUpgradeableItem)) {
            return;
        }
        IUpgradeableItem upgradeableItem = (IUpgradeableItem)item;
        if (!upgradeableItem.getUpgrades(terminal).isInstalled((ItemLike)AE2wtlibItems.MAGNET_CARD)) {
            return;
        }
        terminal.set(AE2wtlibAdditionalComponents.MAGNET_SETTINGS, (Object)magnetSettings);
    }

    public static MagnetMode getMagnetMode(ItemStack terminal) {
        IUpgradeableItem upgradeableItem;
        Item item = terminal.getItem();
        if (item instanceof IUpgradeableItem && Upgrades.getMaxInstallable((ItemLike)AE2wtlibItems.MAGNET_CARD, (ItemLike)(upgradeableItem = (IUpgradeableItem)item)) != 0) {
            if (upgradeableItem.getUpgrades(terminal).isInstalled((ItemLike)AE2wtlibItems.MAGNET_CARD)) {
                return (MagnetMode)((Object)terminal.getOrDefault(AE2wtlibAdditionalComponents.MAGNET_SETTINGS, (Object)MagnetMode.OFF));
            }
            return MagnetMode.NO_CARD;
        }
        return MagnetMode.INVALID;
    }
}

