/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item.component;

import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.mojang.serialization.MapCodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record EmitRedstoneBehavior() implements FunctionalUpgradeBehavior
{
    public static final EmitRedstoneBehavior INSTANCE = new EmitRedstoneBehavior();
    public static final MapCodec<EmitRedstoneBehavior> CODEC = MapCodec.unit((Object)INSTANCE);

    @Override
    public void work(Level level, BlockPos pos, ControllableDrawerTile<?> drawer, ItemStack upgradeStack, int upgradeSlot) {
        if (level.getGameTime() % 20L == 0L) {
            level.updateNeighborsAt(pos, (Block)drawer.getBasicTileBlock());
        }
    }

    @Override
    public boolean canConnectRedstone(Level level, BlockPos blockPos, BlockState state, ControllableDrawerTile<?> drawer, Direction direction, ItemStack upgradeStack, int upgradeSlot) {
        return drawer instanceof ItemControllableDrawerTile || drawer instanceof FluidDrawerTile;
    }

    @Override
    public int getRedstoneSignal(Level level, BlockPos blockPos, BlockState state, ControllableDrawerTile<?> drawer, Direction direction, ItemStack upgradeStack, int upgradeSlot) {
        ControllableDrawerTile<?> controllableDrawerTile = drawer;
        Objects.requireNonNull(controllableDrawerTile);
        ControllableDrawerTile<?> controllableDrawerTile2 = controllableDrawerTile;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemControllableDrawerTile.class, FluidDrawerTile.class}, controllableDrawerTile2, n)) {
            case 0 -> {
                ItemControllableDrawerTile itemDrawer = (ItemControllableDrawerTile)controllableDrawerTile2;
                int redstoneSlot = (Integer)upgradeStack.getOrDefault(FSAttachments.SLOT, (Object)0);
                if (redstoneSlot < itemDrawer.getStorage().getSlots()) {
                    int amount;
                    yield amount + ((amount = (int)Math.floor((float)itemDrawer.getStorage().getStackInSlot(redstoneSlot).getCount() * 14.0f / (float)itemDrawer.getStorage().getSlotLimit(redstoneSlot))) > 0 ? 1 : 0);
                }
                yield -1;
            }
            case 1 -> {
                FluidDrawerTile fluidDrawer = (FluidDrawerTile)controllableDrawerTile2;
                int redstoneSlot = (Integer)upgradeStack.getOrDefault(FSAttachments.SLOT, (Object)0);
                if (redstoneSlot < fluidDrawer.getFluidHandler().getTanks()) {
                    yield (int)Math.floor((float)fluidDrawer.getFluidHandler().getFluidInTank(redstoneSlot).getAmount() * 15.0f / (float)fluidDrawer.getFluidHandler().getTankCapacity(redstoneSlot));
                }
                yield -1;
            }
            default -> -1;
        };
    }

    @Override
    public MapCodec<? extends FunctionalUpgradeBehavior> codec() {
        return CODEC;
    }
}

