/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.standard;

import de.markusbordihn.easynpc.client.model.EasyNPCModel;
import de.markusbordihn.easynpc.client.model.ModelHelper;
import de.markusbordihn.easynpc.client.model.ModelPartType;
import de.markusbordihn.easynpc.client.model.animation.HumanoidLegAnimation;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackData;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;

public class StandardVillagerModel<T extends Entity>
extends VillagerModel<T>
implements EasyNPCModel<T> {
    protected final Map<ModelPartType, CustomPosition> modelPartPositionMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
    protected final Map<ModelPartType, CustomRotation> modelPartRotationMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
    protected final Map<ModelPartType, Boolean> modelPartVisibilityMap = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
    protected final Map<ModelPartType, ModelPart> modelPartMap = new EnumMap<ModelPartType, ModelPart>(ModelPartType.class);
    private final ModelPart arms;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public StandardVillagerModel(ModelPart modelPart) {
        super(modelPart);
        this.arms = this.defineModelPart(ModelPartType.ARMS, modelPart, "arms");
        this.body = this.defineModelPart(ModelPartType.BODY, modelPart, "body");
        this.head = this.defineModelPart(ModelPartType.HEAD, modelPart, "head");
        this.leftLeg = this.defineModelPart(ModelPartType.LEFT_LEG, modelPart, "left_leg");
        this.rightLeg = this.defineModelPart(ModelPartType.RIGHT_LEG, modelPart, "right_leg");
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!this.setupAnimation((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch)) {
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Override
    public void resetModelParts() {
        this.resetModelPart(ModelPartType.ARMS, this.arms);
        this.resetModelPart(ModelPartType.HEAD, this.head);
        this.resetModelPart(ModelPartType.BODY, this.body);
        this.resetModelPart(ModelPartType.RIGHT_LEG, this.rightLeg);
        this.resetModelPart(ModelPartType.LEFT_LEG, this.leftLeg);
    }

    @Override
    public void setupCustomModelPose(T entity, ModelPose modelPose, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelHelper.setPositionRotationVisibility(this.head, modelData.getModelHeadPosition(), modelData.getModelHeadRotation(), modelData.isModelHeadVisible());
        ModelHelper.setPositionRotationVisibility(this.body, modelData.getModelBodyPosition(), modelData.getModelBodyRotation(), modelData.isModelBodyVisible());
        ModelHelper.setPositionRotationVisibility(this.arms, modelData.getModelArmsPosition(), modelData.getModelArmsRotation(), modelData.isModelArmsVisible());
        ModelHelper.setPositionRotationVisibility(this.leftLeg, modelData.getModelLeftLegPosition(), modelData.getModelLeftLegRotation(), modelData.isModelLeftLegVisible());
        ModelHelper.setPositionRotationVisibility(this.rightLeg, modelData.getModelRightLegPosition(), modelData.getModelRightLegRotation(), modelData.isModelRightLegVisible());
    }

    @Override
    public boolean animateModelHead(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart headPart, float ageInTicks, float netHeadYaw, float headPitch) {
        headPart.xRot = headPitch * ((float)Math.PI / 180);
        headPart.yRot = netHeadYaw * ((float)Math.PI / 180);
        return true;
    }

    @Override
    public boolean animateModelLegs(T entity, AttackData<?> attackData, ModelData<?> modelData, ModelPart rightLegPart, ModelPart leftLegPart, float ageInTicks, float limbSwing, float limbSwingAmount) {
        return HumanoidLegAnimation.animateHumanoidModelLegs(rightLegPart, leftLegPart, ageInTicks, limbSwing, limbSwingAmount);
    }

    @Override
    public boolean setupCrouchingModelPose(T entity, ModelData<?> modelData, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.arms.xRot += 0.4f;
        this.arms.y = 5.2f;
        this.body.xRot = 0.5f;
        this.body.y = 3.2f;
        this.head.y = 4.2f;
        this.leftLeg.y = 12.2f;
        this.leftLeg.z = 4.0f;
        this.rightLeg.y = 12.2f;
        this.rightLeg.z = 4.0f;
        return true;
    }

    @Override
    public Map<ModelPartType, CustomPosition> getModelPartPositionMap() {
        return this.modelPartPositionMap;
    }

    @Override
    public Map<ModelPartType, CustomRotation> getModelPartRotationMap() {
        return this.modelPartRotationMap;
    }

    @Override
    public Map<ModelPartType, Boolean> getModelPartVisibilityMap() {
        return this.modelPartVisibilityMap;
    }

    @Override
    public Map<ModelPartType, ModelPart> getModelPartMap() {
        return this.modelPartMap;
    }
}

