/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.custom.OrcModel;
import de.markusbordihn.easynpc.client.renderer.entity.base.BaseHumanoidMobModelRenderer;
import de.markusbordihn.easynpc.entity.easynpc.npc.Orc;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class OrcModelRenderer
extends BaseHumanoidMobModelRenderer<Orc, Orc.Variant, OrcModel<Orc>> {
    protected static final Map<Orc.Variant, ResourceLocation> TEXTURE_BY_VARIANT = (Map)Util.make(new EnumMap(Orc.Variant.class), map -> {
        map.put(Orc.Variant.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/orc/orc_default.png"));
        map.put(Orc.Variant.WARRIOR, ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"textures/entity/orc/orc_warrior.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT.get((Object)Orc.Variant.DEFAULT);

    public OrcModelRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, new OrcModel(context.bakeLayer(modelLayerLocation)), 0.3f, DEFAULT_TEXTURE, TEXTURE_BY_VARIANT);
    }

    @Override
    public void renderDefaultPose(Orc entity, OrcModel<Orc> model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        switch (pose) {
            case DYING: {
                poseStack.translate(-0.5, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees((LivingEntity)entity)));
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                model.getHead().xRot = -0.7853982f;
                model.getHead().yRot = -0.7853982f;
                model.getHead().zRot = -0.7853982f;
                break;
            }
            case LONG_JUMPING: {
                model.leftArmPose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                model.rightArmPose = HumanoidModel.ArmPose.SPYGLASS;
                break;
            }
            case SLEEPING: {
                poseStack.translate(0.5, 0.0, 0.0);
                break;
            }
            case SPIN_ATTACK: {
                model.leftArmPose = HumanoidModel.ArmPose.BLOCK;
                model.rightArmPose = HumanoidModel.ArmPose.THROW_SPEAR;
                poseStack.mulPose(Axis.YP.rotationDegrees(-35.0f));
                break;
            }
            default: {
                model.leftArmPose = HumanoidModel.ArmPose.EMPTY;
                model.rightArmPose = HumanoidModel.ArmPose.EMPTY;
                model.getHead().xRot = 0.0f;
                model.getHead().yRot = 0.0f;
                model.getHead().zRot = 0.0f;
            }
        }
    }
}

