/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.easynpc.client.screen.ScreenInterface;
import de.markusbordihn.easynpc.client.screen.components.CloseButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.EasyNPCMenu;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

public class Screen<T extends EasyNPCMenu>
extends net.minecraft.client.gui.screens.Screen
implements MenuAccess<T>,
ScreenInterface {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final int UPDATE_TICKS = 8;
    protected static double formerMouseX = -1.0;
    protected static double formerMouseY = -1.0;
    protected final Minecraft minecraftInstance;
    protected final T menu;
    protected final int imageWidth;
    protected final int imageHeight;
    protected float xMouse;
    protected float yMouse;
    protected int rightPos;
    protected int bottomPos;
    protected boolean renderBackground = true;
    protected boolean showCloseButton = true;
    protected Button closeButton = null;
    protected boolean compactMode = false;
    protected int titleLabelX;
    protected int titleLabelY;
    protected int leftPos;
    protected int topPos;
    private int updateTicker = 0;

    protected Screen(T menu, Inventory inventory, Component component) {
        this(menu, inventory, component, 318, 243);
    }

    protected Screen(T menu, Inventory inventory, Component component, int width, int height) {
        super(component);
        this.imageWidth = width;
        this.imageHeight = height;
        this.menu = menu;
        this.minecraftInstance = Minecraft.getInstance();
    }

    protected static void resetFormerMousePosition() {
        Screen.setFormerMousePosition(-1.0, -1.0);
    }

    protected static void setFormerMousePosition(double x, double y) {
        formerMouseX = x;
        formerMouseY = y;
    }

    @Override
    public UUID getEasyNPCUUID() {
        return ((EasyNPCMenu)((Object)this.menu)).getNpcUUID();
    }

    @Override
    public EasyNPC<?> getEasyNPC() {
        return ((EasyNPCMenu)((Object)this.menu)).getEasyNPC();
    }

    @Override
    public ScreenData getScreenData() {
        return ((EasyNPCMenu)((Object)this.menu)).getScreenData();
    }

    @Override
    public AdditionalScreenData getAdditionalScreenData() {
        return ((EasyNPCMenu)((Object)this.menu)).getAdditionalScreenData();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void closeScreen() {
        if (this.minecraftInstance != null) {
            this.minecraftInstance.setScreen(null);
        }
        this.onClose();
    }

    protected void init() {
        super.init();
        this.compactMode = this.height < 260;
        this.titleLabelX = 7;
        this.titleLabelY = -9;
        this.topPos = (this.height - this.imageHeight) / 2 + (this.compactMode ? 2 : 10);
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.rightPos = this.leftPos + this.imageWidth;
        this.bottomPos = this.topPos + this.imageHeight;
        if (formerMouseX > 0.0 && formerMouseY > 0.0) {
            GLFW.glfwSetCursorPos((long)this.minecraftInstance.getWindow().getWindow(), (double)formerMouseX, (double)formerMouseY);
            Screen.resetFormerMousePosition();
        }
        if (this.showCloseButton) {
            this.closeButton = (Button)this.addRenderableWidget((GuiEventListener)new CloseButton(this.rightPos - 15, this.topPos + 4, onPress -> this.closeScreen()));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Screen.setFormerMousePosition(Minecraft.getInstance().mouseHandler.xpos(), Minecraft.getInstance().mouseHandler.ypos());
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.xMouse = x;
        this.yMouse = y;
        RenderSystem.disableDepthTest();
        super.render(guiGraphics, x, y, partialTicks);
        RenderSystem.enableDepthTest();
    }

    public void renderBackground(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        if (this.renderBackground) {
            super.renderBackground(guiGraphics, x, y, partialTicks);
        }
        this.renderBg(guiGraphics, partialTicks, x, y);
        this.renderLabels(guiGraphics, x, y);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.renderDefaultScreenBg(guiGraphics, this.leftPos, this.topPos);
        if (!this.compactMode) {
            this.renderDefaultTitleBg(guiGraphics, this.leftPos, this.topPos);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        Text.drawString(guiGraphics, this.font, this.title, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, 0x404040);
    }

    protected void updateTick() {
    }

    public final void tick() {
        super.tick();
        if (this.minecraft.player.isAlive() && !this.minecraft.player.isRemoved() && this.updateTicker++ % 8 == 0) {
            this.updateTick();
        }
    }

    public void onClose() {
        Screen.resetFormerMousePosition();
        super.onClose();
    }

    public boolean keyPressed(int keyCode, int unused1, int unused2) {
        if (keyCode != 257 && keyCode != 335 && keyCode != 69 && keyCode != 73) {
            return super.keyPressed(keyCode, unused1, unused2);
        }
        return keyCode == 257 || keyCode == 335 || keyCode == 73;
    }

    public T getMenu() {
        return this.menu;
    }
}

