/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.attribute.BaseAttributes;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationData;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerData;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinData;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public interface ScreenInterface {
    public EasyNPC<?> getEasyNPC();

    public ScreenData getScreenData();

    public AdditionalScreenData getAdditionalScreenData();

    default public UUID getEasyNPCUUID() {
        return this.getScreenData().uuid();
    }

    default public Entity getEasyNPCEntity() {
        return this.getEasyNPC() != null ? this.getEasyNPC().getEntity() : null;
    }

    default public LivingEntity getEasyNPCLivingEntity() {
        return this.getEasyNPC() != null ? this.getEasyNPC().getLivingEntity() : null;
    }

    default public OwnerData<?> getOwnerData() {
        return this.getEasyNPC().getEasyNPCOwnerData();
    }

    default public SkinModel getSkinModel() {
        if (this.getEasyNPCEntity() == null) {
            return null;
        }
        EasyNPC<?> easyNPC = this.getEasyNPC();
        SkinData<?> skinData = easyNPC.getEasyNPCSkinData();
        return skinData != null ? skinData.getSkinModel() : null;
    }

    default public Component getDialogText() {
        return this.hasDialogData() ? this.getDialogData().getDialogText() : null;
    }

    default public UUID getDialogUUID() {
        return this.getScreenData().dialogId();
    }

    default public UUID getDialogButtonUUID() {
        return this.getScreenData().dialogButtonId();
    }

    default public UUID getActionDataEntryUUID() {
        return this.getScreenData().actionDataEntryId();
    }

    default public int getPageIndex() {
        return this.getScreenData().pageIndex();
    }

    default public ActionEventSet getActionEventSet() {
        return this.getAdditionalScreenData().getActionEventSet();
    }

    default public BaseAttributes getBaseAttributes() {
        return this.getAdditionalScreenData().getBaseAttributes();
    }

    default public ConfigurationData<?> getConfigurationData() {
        return this.getEasyNPC().getEasyNPCConfigurationData();
    }

    default public DialogDataSet getDialogDataSet() {
        return this.getAdditionalScreenData().getDialogDataSet();
    }

    default public ObjectiveDataSet getObjectiveDataSet() {
        return this.getAdditionalScreenData().getObjectiveDataSet();
    }

    default public RenderDataSet getRenderDataSet() {
        return this.getEasyNPC().getEasyNPCRenderData().getRenderDataSet();
    }

    default public boolean hasDialogData() {
        return this.getDialogData() != null;
    }

    default public DialogDataEntry getDialogData() {
        return this.getScreenData().dialogId() != null ? this.getDialogData(this.getScreenData().dialogId()) : this.getDialogDataSet().getDefaultDialog();
    }

    default public DialogDataEntry getDialogData(UUID dialogUUID) {
        return this.getDialogDataSet().getDialog(dialogUUID);
    }

    default public DialogButtonEntry getDialogButtonData() {
        if (!this.hasDialog() || this.getScreenData().dialogButtonId() == null) {
            return null;
        }
        DialogDataEntry dialogData = this.getDialogData();
        if (dialogData == null) {
            return null;
        }
        return dialogData.getDialogButton(this.getScreenData().dialogButtonId());
    }

    default public boolean hasDialog() {
        return this.getDialogDataSet().hasDialog();
    }

    default public void renderDefaultScreenBg(GuiGraphics guiGraphics, int leftPos, int topPos) {
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos, topPos, 0, 0, 220, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos + 213, topPos, 132, 0, 120, 160);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos, topPos + 77, 0, 5, 220, 170);
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos + 213, topPos + 77, 132, 5, 120, 170);
    }

    default public void renderDefaultTitleBg(GuiGraphics guiGraphics, int leftPos, int topPos) {
        Graphics.blit(guiGraphics, Constants.TEXTURE_DEMO_BACKGROUND, leftPos, topPos - 16, 0, 0, 248, 19);
    }
}

