/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.dialog;

import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.AdvancedDialogConfigurationScreen;
import de.markusbordihn.easynpc.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class AdvancedDialogConfigurationScreen<T extends ConfigurationMenu>
extends DialogConfigurationScreen<T> {
    Button newDialogButton;
    DialogList dialogList;

    public AdvancedDialogConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        super.init();
        this.advancedDialogButton.active = false;
        this.newDialogButton = (Button)this.addRenderableWidget((GuiEventListener)new AddButton(this.contentLeftPos + 2, this.contentTopPos + 193, 300, "dialog.add", onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID())));
        this.dialogList = new DialogList();
        this.addWidget((GuiEventListener)this.dialogList);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        guiGraphics.fill(this.leftPos + 5, this.contentTopPos + 20, this.leftPos + 324, this.contentTopPos + 210, -1118482);
        guiGraphics.fill(this.leftPos + 109, this.contentTopPos + 20, this.leftPos + 110, this.contentTopPos + 190, -4473925);
        guiGraphics.fill(this.leftPos + 208, this.contentTopPos + 20, this.leftPos + 209, this.contentTopPos + 190, -4473925);
        if (this.dialogList != null) {
            this.dialogList.renderSelectionList(guiGraphics, x, y, partialTicks);
        }
        guiGraphics.fill(this.leftPos + 5, this.contentTopPos, this.leftPos + 324, this.contentTopPos + 18, -5592406);
        guiGraphics.fill(this.leftPos + 5, this.contentTopPos + 191, this.leftPos + 324, this.contentTopPos + 211, -3750202);
        int headerLeft = this.leftPos + 10;
        Text.drawConfigString(guiGraphics, this.font, "label_id", headerLeft, this.contentTopPos + 5, 0);
        Text.drawString(guiGraphics, this.font, "Name", headerLeft + 103, this.contentTopPos + 5, 0);
        Text.drawString(guiGraphics, this.font, "Text", headerLeft + 201, this.contentTopPos + 5, 0);
        guiGraphics.fill(this.leftPos + 109, this.contentTopPos, this.leftPos + 110, this.contentTopPos + 18, -10066330);
        guiGraphics.fill(this.leftPos + 208, this.contentTopPos, this.leftPos + 209, this.contentTopPos + 18, -10066330);
        if (this.newDialogButton != null) {
            this.newDialogButton.render(guiGraphics, x, y, partialTicks);
        }
    }

    class DialogList
    extends ObjectSelectionList<de.markusbordihn.easynpc.client.screen.configuration.dialog.AdvancedDialogConfigurationScreen$DialogList.Entry> {
        DialogList() {
            super(AdvancedDialogConfigurationScreen.this.minecraft, AdvancedDialogConfigurationScreen.this.width + 50, 177, AdvancedDialogConfigurationScreen.this.contentTopPos + 15, 19);
            this.setRenderHeader(false, 0);
            for (DialogDataEntry dialogData : AdvancedDialogConfigurationScreen.this.getDialogDataSet().getDialogsByLabel()) {
                if (dialogData == null || dialogData.getId() == null) continue;
                this.addEntry((AbstractSelectionList.Entry)new Entry(dialogData));
            }
        }

        public void renderSelectionList(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
            if (this.getItemCount() > 0) {
                super.render(guiGraphics, x, y, partialTicks);
            }
        }

        protected void renderSelection(GuiGraphics guiGraphics, int unused1, int unused2, int unused3, int unused4, int unused5) {
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
        }

        class Entry
        extends ObjectSelectionList.Entry<de.markusbordihn.easynpc.client.screen.configuration.dialog.AdvancedDialogConfigurationScreen$DialogList.Entry> {
            final DialogDataEntry dialogData;
            final EditButton editButton;
            final CopyButton copyLabelButton;
            final TextEditButton textEditButton;
            final String defaultDialogLabel;

            public Entry(DialogDataEntry dialogData) {
                this.dialogData = dialogData;
                this.editButton = new EditButton(0, 0, onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(AdvancedDialogConfigurationScreen.this.getEasyNPCUUID(), this.dialogData.getId()));
                this.copyLabelButton = new CopyButton(0, 0, onPress -> {
                    Minecraft minecraft = Minecraft.getInstance();
                    minecraft.keyboardHandler.setClipboard(dialogData.getLabel());
                });
                this.textEditButton = new TextEditButton(0, 0, onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogTextEditor(AdvancedDialogConfigurationScreen.this.getEasyNPCUUID(), this.dialogData.getId()));
                this.defaultDialogLabel = AdvancedDialogConfigurationScreen.this.getDialogDataSet().getDefaultDialogLabel();
            }

            public Component getNarration() {
                return TextComponent.getTextComponent(this.dialogData.getName());
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                super.mouseClicked(mouseX, mouseY, button);
                this.copyLabelButton.mouseClicked(mouseX, mouseY, button);
                this.editButton.mouseClicked(mouseX, mouseY, button);
                this.textEditButton.mouseClicked(mouseX, mouseY, button);
                return button == 0;
            }

            public void render(GuiGraphics guiGraphics, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
                int leftPos = left - 75;
                this.editButton.setX(leftPos + 71);
                this.editButton.setY(top);
                this.editButton.render(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.editButton.isHovered()) {
                    guiGraphics.renderTooltip(AdvancedDialogConfigurationScreen.this.font, (Component)TextComponent.getTranslatedConfigText("dialog.edit_dialog", this.dialogData.getName()), mouseX, mouseY);
                }
                this.copyLabelButton.setX(this.editButton.getX() + this.editButton.getWidth());
                this.copyLabelButton.setY(top);
                this.copyLabelButton.render(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.copyLabelButton.isHovered()) {
                    guiGraphics.renderTooltip(AdvancedDialogConfigurationScreen.this.font, (Component)TextComponent.getTranslatedConfigText("dialog.copy_dialog_label", this.dialogData.getLabel()), mouseX, mouseY);
                }
                this.textEditButton.setX(leftPos + 203);
                this.textEditButton.setY(top);
                this.textEditButton.render(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.textEditButton.isHovered()) {
                    guiGraphics.renderTooltip(AdvancedDialogConfigurationScreen.this.font, (Component)TextComponent.getTranslatedConfigText("dialog.edit_dialog_text", this.dialogData.getText()), mouseX, mouseY);
                }
                float dialogDataScale = 0.75f;
                int dialogDataTopPos = Math.round((float)(top + 5) / dialogDataScale);
                int fontColor = this.dialogData.getLabel().equals(this.defaultDialogLabel) ? 43520 : 0;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(dialogDataScale, dialogDataScale, dialogDataScale);
                Text.drawString(guiGraphics, AdvancedDialogConfigurationScreen.this.font, this.dialogData.getLabel(16), Math.round((float)(leftPos + 4) / dialogDataScale), dialogDataTopPos, fontColor);
                Text.drawString(guiGraphics, AdvancedDialogConfigurationScreen.this.font, this.dialogData.getName(21), Math.round((float)(leftPos + 109) / dialogDataScale), dialogDataTopPos, fontColor);
                Text.drawString(guiGraphics, AdvancedDialogConfigurationScreen.this.font, this.dialogData.getText(21), Math.round((float)(leftPos + 221) / dialogDataScale), dialogDataTopPos, fontColor);
                guiGraphics.pose().popPose();
                guiGraphics.fill(AdvancedDialogConfigurationScreen.this.leftPos + 5, top + 17, AdvancedDialogConfigurationScreen.this.leftPos + 324, top + 18, -5592406);
            }
        }
    }
}

