/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.configuration.scaling;

import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.data.model.ModelScaleAxis;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ScalingConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    private static final int DIMENSION_UPDATE_TICK = 20;
    protected Button defaultScaleButton;
    protected Button defaultScaleXButton;
    protected Button defaultScaleYButton;
    protected Button defaultScaleZButton;
    protected RangeSliderButton scaleXSliderButton;
    protected RangeSliderButton scaleYSliderButton;
    protected RangeSliderButton scaleZSliderButton;
    private int dimensionUpdateTicker = 0;

    public ScalingConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        super.init();
        int buttonWidth = 80;
        this.defaultScaleButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth, "scaling", button -> {}));
        this.defaultScaleButton.active = false;
        int scalePositionLeft = this.contentLeftPos + 165;
        int scalePositionTop = this.contentTopPos + 20;
        int scalePositionSpace = 60;
        int scaleWidth = 140;
        int scaleHeight = 20;
        ScaleData<?> scaleData = this.getEasyNPC().getEasyNPCScaleData();
        this.scaleXSliderButton = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(scalePositionLeft, scalePositionTop, scaleWidth, scaleHeight, scaleData.getScaleX().floatValue(), scaleData.getDefaultScaleX().floatValue(), SliderButton.Type.SCALE, slider -> {
            float scale = slider.getTargetValue();
            if (scaleData.getScaleX().floatValue() != scale) {
                NetworkMessageHandlerManager.getServerHandler().scaleChange(this.getEasyNPCUUID(), ModelScaleAxis.X, slider.getTargetValue());
            }
        }));
        this.scaleYSliderButton = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(scalePositionLeft, scalePositionTop + scalePositionSpace, scaleWidth, scaleHeight, scaleData.getScaleY().floatValue(), scaleData.getDefaultScaleY().floatValue(), SliderButton.Type.SCALE, button -> {
            float scale = button.getTargetValue();
            if (scaleData.getScaleY().floatValue() != scale) {
                NetworkMessageHandlerManager.getServerHandler().scaleChange(this.getEasyNPCUUID(), ModelScaleAxis.Y, button.getTargetValue());
            }
        }));
        this.scaleZSliderButton = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)new RangeSliderButton(scalePositionLeft, scalePositionTop + scalePositionSpace * 2, scaleWidth, scaleHeight, scaleData.getScaleZ().floatValue(), scaleData.getDefaultScaleZ().floatValue(), SliderButton.Type.SCALE, button -> {
            float scale = button.getTargetValue();
            if (scaleData.getScaleZ().floatValue() != scale) {
                NetworkMessageHandlerManager.getServerHandler().scaleChange(this.getEasyNPCUUID(), ModelScaleAxis.Z, button.getTargetValue());
            }
        }));
    }

    @Override
    public void updateTick() {
        super.updateTick();
        if (this.getEasyNPCEntity() != null && this.dimensionUpdateTicker++ > 20) {
            this.getEasyNPCEntity().refreshDimensions();
            this.dimensionUpdateTicker = 0;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        ScreenHelper.renderEntityAvatarForScaling(guiGraphics, this.contentLeftPos + 80, this.contentTopPos + 192, 30, (float)(this.contentLeftPos + 75) - this.xMouse, (float)(this.contentTopPos + 120) - this.yMouse, this.getEasyNPC());
        Text.drawConfigString(guiGraphics, this.font, "scale_x", this.scaleXSliderButton.getX(), this.scaleXSliderButton.getY() - 10);
        Text.drawConfigString(guiGraphics, this.font, "scale_y", this.scaleYSliderButton.getX(), this.scaleYSliderButton.getY() - 10);
        Text.drawConfigString(guiGraphics, this.font, "scale_z", this.scaleZSliderButton.getX(), this.scaleZSliderButton.getY() - 10);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        String[] scaleValues;
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.fill(this.contentLeftPos, this.contentTopPos, this.contentLeftPos + 159, this.contentTopPos + 207, -16777216);
        guiGraphics.fill(this.contentLeftPos + 1, this.contentTopPos + 1, this.contentLeftPos + 158, this.contentTopPos + 206, -5592406);
        int scaleLinesColor = -1437248171;
        int scaleLinesTop = this.contentTopPos + 193;
        int scaleLinesLeft = this.contentLeftPos + 4;
        for (String scaleValue : scaleValues = new String[]{"  0", "0.5", "1.0", "1.5", "2.0", "2.5", "3.0"}) {
            Text.drawString(guiGraphics, this.font, scaleValue, scaleLinesLeft, scaleLinesTop - 4, scaleLinesColor);
            guiGraphics.fill(this.contentLeftPos + 20, scaleLinesTop - 1, this.contentLeftPos + 152, scaleLinesTop, scaleLinesColor);
            scaleLinesTop -= 31;
        }
    }
}

