/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.display;

import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import net.minecraft.nbt.CompoundTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record DisplayAttributeEntry(DisplayAttributeType displayAttributeType, boolean booleanValue, int intValue) {
    public static final String DATA_TYPE_TAG = "Type";
    public static final String DATA_BOOLEAN_VALUE_TAG = "Boolean";
    public static final String DATA_INT_VALUE_TAG = "Int";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC");

    public DisplayAttributeEntry(CompoundTag compoundTag) {
        this(DisplayAttributeType.get(compoundTag.getString(DATA_TYPE_TAG)), compoundTag.getBoolean(DATA_BOOLEAN_VALUE_TAG), compoundTag.contains(DATA_INT_VALUE_TAG) ? compoundTag.getInt(DATA_INT_VALUE_TAG) : 0);
    }

    public DisplayAttributeEntry create(CompoundTag compoundTag) {
        return new DisplayAttributeEntry(compoundTag);
    }

    public CompoundTag write(CompoundTag compoundTag) {
        compoundTag.putString(DATA_TYPE_TAG, this.displayAttributeType.name());
        compoundTag.putBoolean(DATA_BOOLEAN_VALUE_TAG, this.booleanValue);
        if (this.intValue != 0) {
            compoundTag.putInt(DATA_INT_VALUE_TAG, this.intValue);
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.write(new CompoundTag());
    }

    @Override
    public String toString() {
        return "DisplayAttributeEntry{displayAttributeType=" + String.valueOf((Object)this.displayAttributeType) + ", boolean=" + this.booleanValue + ", int=" + this.intValue + "}";
    }
}

