/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class Illager
extends EasyNPCBaseModelEntity<Illager> {
    public static final String ID_EVOKER = "evoker";
    public static final String ID_ILLUSIONER = "illusioner";
    public static final String ID_PILLAGER = "pillager";
    public static final String ID_VINDICATOR = "vindicator";

    public Illager(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variant) {
        super(entityType, level, variant);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, (double)0.6f).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    @Override
    public boolean canUseArmor() {
        return false;
    }

    @Override
    public boolean hasArmsModelPart() {
        return true;
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.ILLAGER;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.PILLAGER;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        Variant soundVariant = Variant.valueOf(variantName);
        switch (soundVariant.ordinal()) {
            case 0: 
            case 1: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.EVOKER_AMBIENT);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.EVOKER_DEATH);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.EVOKER_HURT);
                soundDataSet.addSound(SoundType.CAST_SPELL, SoundEvents.EVOKER_CAST_SPELL);
                soundDataSet.addSound(SoundType.CELEBRATE, SoundEvents.EVOKER_CELEBRATE);
                break;
            }
            case 2: 
            case 3: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.ILLUSIONER_AMBIENT);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.ILLUSIONER_DEATH);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.ILLUSIONER_HURT);
                soundDataSet.addSound(SoundType.CAST_SPELL, SoundEvents.ILLUSIONER_CAST_SPELL);
                soundDataSet.addSound(SoundType.CELEBRATE, SoundEvents.PILLAGER_CELEBRATE);
                break;
            }
            case 5: 
            case 6: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.VINDICATOR_AMBIENT);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.VINDICATOR_DEATH);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.VINDICATOR_HURT);
                soundDataSet.addSound(SoundType.CELEBRATE, SoundEvents.VINDICATOR_CELEBRATE);
                break;
            }
            default: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.PILLAGER_AMBIENT);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.PILLAGER_DEATH);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.PILLAGER_HURT);
                soundDataSet.addSound(SoundType.CELEBRATE, SoundEvents.PILLAGER_CELEBRATE);
            }
        }
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    public static enum Variant {
        EVOKER,
        EVOKER_CROSSED_ARMS,
        ILLUSIONER,
        ILLUSIONER_CROSSED_ARMS,
        PILLAGER,
        VINDICATOR,
        VINDICATOR_CROSSED_ARMS;

    }
}

