/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class Piglin
extends EasyNPCBaseModelEntity<Piglin> {
    public static final String ID = "piglin";
    public static final String ID_BRUTE = "piglin_brute";
    public static final String ID_ZOMBIFIED = "piglin_zombified";

    public Piglin(EntityType<? extends PathfinderMob> entityType, Level level) {
        this(entityType, level, Variant.PIGLIN);
    }

    public Piglin(EntityType<? extends PathfinderMob> entityType, Level level, Enum<?> variant) {
        super(entityType, level, variant);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.PIGLIN;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.PIGLIN;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        Variant soundVariant = Variant.valueOf(variantName);
        switch (soundVariant.ordinal()) {
            case 1: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.PIGLIN_BRUTE_AMBIENT);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.PIGLIN_BRUTE_HURT);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.PIGLIN_BRUTE_DEATH);
                soundDataSet.addSound(SoundType.STEP, SoundEvents.PIGLIN_BRUTE_STEP);
                break;
            }
            case 2: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.ZOMBIFIED_PIGLIN_AMBIENT);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.ZOMBIFIED_PIGLIN_HURT);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.ZOMBIFIED_PIGLIN_DEATH);
                soundDataSet.addSound(SoundType.STEP, SoundEvents.PIGLIN_STEP);
                break;
            }
            default: {
                soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.PIGLIN_AMBIENT);
                soundDataSet.addSound(SoundType.HURT, SoundEvents.PIGLIN_HURT);
                soundDataSet.addSound(SoundType.DEATH, SoundEvents.PIGLIN_DEATH);
                soundDataSet.addSound(SoundType.STEP, SoundEvents.PIGLIN_STEP);
            }
        }
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    public static enum Variant {
        PIGLIN,
        PIGLIN_BRUTE,
        ZOMBIFIED_PIGLIN;

    }
}

