/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseModelEntity;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class Villager
extends EasyNPCBaseModelEntity<Villager> {
    public static final String ID = "villager";

    public Villager(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level, Variant.DEFAULT);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, (double)0.6f).add(Attributes.ATTACK_DAMAGE, 0.5).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    @Override
    public SkinModel getSkinModel() {
        return SkinModel.VILLAGER;
    }

    @Override
    public boolean hasArmsModelPart() {
        return true;
    }

    @Override
    public boolean hasLeftArmModelPart() {
        return false;
    }

    @Override
    public boolean hasRightArmModelPart() {
        return false;
    }

    @Override
    public boolean canUseArmor() {
        return false;
    }

    @Override
    public boolean canUseOffHand() {
        return false;
    }

    @Override
    public Component getName() {
        Component component = this.getCustomName();
        if (component != null) {
            return TextUtils.removeAction(component);
        }
        Component professionName = this.getProfessionName();
        Component variantName = this.getVariantName();
        return TextComponent.getText(variantName.getString() + " (" + professionName.getString() + ")");
    }

    @Override
    public boolean hasProfessions() {
        return true;
    }

    @Override
    public Enum<?>[] getVariants() {
        return Variant.values();
    }

    @Override
    public Enum<?> getDefaultVariant() {
        return Variant.DEFAULT;
    }

    @Override
    public Enum<?> getVariant(String name) {
        try {
            return Variant.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return this.getDefaultVariant();
        }
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addSound(SoundType.AMBIENT, SoundEvents.VILLAGER_AMBIENT);
        soundDataSet.addSound(SoundType.DEATH, SoundEvents.VILLAGER_DEATH);
        soundDataSet.addSound(SoundType.HURT, SoundEvents.VILLAGER_HURT);
        soundDataSet.addSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    public static enum Variant {
        DEFAULT,
        DESERT,
        JUNGLE,
        PLAINS,
        SAVANNA,
        SNOW,
        SWAMP,
        TAIGA;

    }
}

