/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NameHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");

    private NameHandler() {
    }

    public static boolean setCustomName(EasyNPC<?> easyNPC, String name, int color, boolean visible) {
        if (easyNPC == null || name == null) {
            log.error("[{}] Error setting custom name {}", easyNPC, (Object)name);
            return false;
        }
        Entity entity = easyNPC.getEntity();
        if (name.isEmpty()) {
            log.debug("[{}] Remove custom name", easyNPC);
            entity.setCustomName(null);
            entity.setCustomNameVisible(false);
            return true;
        }
        log.debug("[{}] Change custom name to '{}' with color {} and visible {}", easyNPC, (Object)name, (Object)color, (Object)visible);
        Style style = Style.EMPTY;
        if (color >= 0) {
            style = style.withColor(TextColor.fromRgb((int)color));
        }
        entity.setCustomName((Component)TextComponent.getTextComponentRaw(name, TextUtils.isTranslationKey(name)).setStyle(style));
        entity.setCustomNameVisible(visible);
        return true;
    }
}

