/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.item.configuration;

import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.EasyNPCBaseEntity;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCWandItem
extends Item {
    public static final String ID = "easy_npc_wand";
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    private static final int GLOWING_DURATION = 80;

    public EasyNPCWandItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        if (selected && entity instanceof Player) {
            Player player = (Player)entity;
            for (EasyNPCBaseEntity easyNPCEntity : level.getEntitiesOfClass(EasyNPCBaseEntity.class, player.getBoundingBox().inflate(0.5), Entity::isAlive)) {
                if (easyNPCEntity.hasEffect(MobEffects.GLOWING)) {
                    MobEffectInstance mobEffect = easyNPCEntity.getEffect(MobEffects.GLOWING);
                    if (mobEffect == null || mobEffect.getDuration() >= 5) continue;
                    easyNPCEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 80, 1, false, false));
                    continue;
                }
                easyNPCEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 80, 1, false, false));
            }
        }
    }

    public InteractionResult useOn(UseOnContext userContext) {
        Level level = userContext.getLevel();
        Player player = userContext.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockPos blockPos = userContext.getClickedPos();
            AABB aabbAbove = new AABB((double)blockPos.getX() - 0.25, (double)blockPos.getY() - 2.0, (double)blockPos.getZ() - 0.25, (double)blockPos.getX() + 0.25, (double)blockPos.getY() + 2.0, (double)blockPos.getZ() + 0.25);
            for (EasyNPCBaseEntity easyNPCEntity : level.getEntitiesOfClass(EasyNPCBaseEntity.class, aabbAbove.inflate(0.5), Entity::isAlive)) {
                if (easyNPCEntity == null) continue;
                MenuManager.getMenuHandler().openConfigurationMenu(ConfigurationType.MAIN, serverPlayer, easyNPCEntity, 0);
                return InteractionResult.SUCCESS;
            }
            AABB aabbAround = new AABB((double)blockPos.getX() - 0.5, (double)blockPos.getY() - 0.5, (double)blockPos.getZ() - 0.5, (double)blockPos.getX() + 1.0, (double)blockPos.getY() + 1.0, (double)blockPos.getZ() + 1.0);
            for (EasyNPCBaseEntity easyNPCEntity : level.getEntitiesOfClass(EasyNPCBaseEntity.class, aabbAround.inflate(0.5), Entity::isAlive)) {
                if (easyNPCEntity == null) continue;
                MenuManager.getMenuHandler().openConfigurationMenu(ConfigurationType.MAIN, serverPlayer, easyNPCEntity, 0);
                return InteractionResult.SUCCESS;
            }
            for (EasyNPCBaseEntity easyNPCEntity : level.getEntitiesOfClass(EasyNPCBaseEntity.class, aabbAround.inflate(2.5), Entity::isAlive)) {
                if (easyNPCEntity == null) continue;
                MenuManager.getMenuHandler().openConfigurationMenu(ConfigurationType.MAIN, serverPlayer, easyNPCEntity, 0);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isFoil(ItemStack itemStack) {
        return true;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        tooltipList.add((Component)TextComponent.getTranslatedTextRaw("text.easy_npc.item.easy_npc_wand"));
    }
}

