/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu;

import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.ClientMenuManager;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCMenu
extends AbstractContainerMenu {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC");
    protected final Level level;
    protected final Player player;
    protected final ScreenData screenData;
    protected final AdditionalScreenData additionalScreenData;
    protected final EasyNPC<?> easyNPC;

    public EasyNPCMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, new CompoundTag());
    }

    public EasyNPCMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, CompoundTag data) {
        super(menuType, containerId);
        this.player = playerInventory.player;
        this.level = playerInventory.player.level();
        ScreenData screenData = this.screenData = this.level.isClientSide() ? ClientMenuManager.getScreenData() : ScreenData.decode(data);
        if (this.screenData == null) {
            log.error("Screen data is missing for menu {} with {}", menuType, (Object)data);
            this.additionalScreenData = null;
            this.easyNPC = null;
            return;
        }
        AdditionalScreenData additionalScreenData = this.additionalScreenData = this.level.isClientSide() ? ClientMenuManager.getAdditionalScreenData() : new AdditionalScreenData(this.screenData.additionalData());
        if (this.additionalScreenData == null) {
            log.warn("Additional screen data is missing  menu {} with {}", menuType, (Object)this.screenData);
        }
        EasyNPC<?> easyNPC = this.easyNPC = this.level.isClientSide ? LivingEntityManager.getEasyNPCEntityByUUID(this.getNpcUUID()) : LivingEntityManager.getEasyNPCEntityByUUID(this.getNpcUUID(), (ServerPlayer)this.player);
        if (this.easyNPC == null) {
            log.error("EasyNPC entity with UUID {} is missing for menu {} with {}", (Object)this.getNpcUUID(), menuType, (Object)this.screenData);
        }
    }

    public ScreenData getScreenData() {
        return this.screenData;
    }

    public AdditionalScreenData getAdditionalScreenData() {
        return this.additionalScreenData;
    }

    public UUID getNpcUUID() {
        return this.screenData.uuid();
    }

    public int getPageIndex() {
        return this.screenData.pageIndex();
    }

    public EasyNPC<?> getEasyNPC() {
        return this.easyNPC;
    }

    public boolean stillValid(Player player) {
        return player.isAlive();
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = slot.getItem();
        if (itemStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return ItemStack.EMPTY;
    }
}

