/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.menu.configuration.equipment;

import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.handler.EquipmentHandler;
import de.markusbordihn.easynpc.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.menu.configuration.equipment.slot.ArmorSlot;
import de.markusbordihn.easynpc.menu.configuration.equipment.slot.HandSlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EquipmentConfigurationMenu
extends ConfigurationMenu {
    protected static final int ARMOR_CONTAINER_SIZE = 4;
    protected static final int HAND_CONTAINER_SIZE = 2;
    protected static final int SLOT_SIZE = 18;
    protected final Container armorContainer;
    protected final Container handContainer;

    public EquipmentConfigurationMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, new CompoundTag());
    }

    public EquipmentConfigurationMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, CompoundTag data) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(4), (Container)new SimpleContainer(2), data);
    }

    public EquipmentConfigurationMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, Container armorContainer, Container handContainer, CompoundTag data) {
        super(menuType, windowId, playerInventory, data);
        EquipmentConfigurationMenu.checkContainerSize((Container)armorContainer, (int)4);
        EquipmentConfigurationMenu.checkContainerSize((Container)handContainer, (int)2);
        this.armorContainer = armorContainer;
        this.handContainer = handContainer;
        this.loadHand();
        ModelData<?> modelData = this.getEasyNPC().getEasyNPCModelData();
        if (modelData == null || modelData.canUseArmor()) {
            this.loadArmor();
            int playerCompanionEquipmentLeftStartPositionY = 44;
            int playerCompanionEquipmentLeftStartPositionX = 98;
            for (int armorSlot = 3; armorSlot >= 0; --armorSlot) {
                this.addSlot(new ArmorSlot(this, this.armorContainer, 3 - armorSlot, playerCompanionEquipmentLeftStartPositionX, playerCompanionEquipmentLeftStartPositionY + armorSlot * 18));
            }
        }
        if (modelData == null || modelData.canUseMainHand()) {
            int playerCompanionMainHandStartPositionY = 119;
            int playerCompanionMainHandStartPositionX = 98;
            this.addSlot(new HandSlot(this, this.handContainer, EquipmentSlot.MAINHAND.getIndex(), playerCompanionMainHandStartPositionX, playerCompanionMainHandStartPositionY));
        }
        if (modelData == null || modelData.canUseOffHand()) {
            int playerCompanionOffHandStartPositionY = 119;
            int playerCompanionOffHandStartPositionX = 178;
            this.addSlot(new HandSlot(this, this.handContainer, EquipmentSlot.OFFHAND.getIndex(), playerCompanionOffHandStartPositionX, playerCompanionOffHandStartPositionY));
        }
        int playerInventoryStartPositionY = 149;
        int playerInventoryStartPositionX = 66;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.addSlot(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, playerInventoryStartPositionX + inventoryColumn * 18, playerInventoryStartPositionY + inventoryRow * 18));
            }
        }
        int hotbarStartPositionY = 209;
        int hotbarStartPositionX = 66;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.addSlot(new Slot((Container)playerInventory, playerInventorySlot, hotbarStartPositionX + playerInventorySlot * 18, hotbarStartPositionY));
        }
    }

    public void loadHand() {
        if (this.level.isClientSide) {
            return;
        }
        log.debug("Load hand {}", (Object)this.getEasyNPC().getLivingEntity().getHandSlots());
        this.handContainer.setItem(0, this.getEasyNPC().getLivingEntity().getItemInHand(InteractionHand.MAIN_HAND));
        this.handContainer.setItem(1, this.getEasyNPC().getLivingEntity().getItemInHand(InteractionHand.OFF_HAND));
        this.handContainer.setChanged();
    }

    public void setHandChanged(InteractionHand hand, ItemStack itemStack) {
        if (this.level.isClientSide) {
            return;
        }
        EquipmentHandler.setHandSlotItem(this.getEasyNPC(), hand, itemStack);
    }

    public void loadArmor() {
        if (this.level.isClientSide) {
            return;
        }
        log.debug("Load armor {}", (Object)this.getEasyNPC().getLivingEntity().getArmorSlots());
        this.armorContainer.setItem(0, this.getEasyNPC().getLivingEntity().getItemBySlot(EquipmentSlot.FEET));
        this.armorContainer.setItem(1, this.getEasyNPC().getLivingEntity().getItemBySlot(EquipmentSlot.LEGS));
        this.armorContainer.setItem(2, this.getEasyNPC().getLivingEntity().getItemBySlot(EquipmentSlot.CHEST));
        this.armorContainer.setItem(3, this.getEasyNPC().getLivingEntity().getItemBySlot(EquipmentSlot.HEAD));
        this.armorContainer.setChanged();
    }

    public void setArmorChanged(EquipmentSlot equipmentSlot, int slot, ItemStack itemStack) {
        if (this.level.isClientSide) {
            return;
        }
        EquipmentHandler.setArmorSlotItem(this.getEasyNPC(), equipmentSlot, itemStack);
    }
}

