/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message;

import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import io.netty.buffer.Unpooled;
import java.util.Random;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface NetworkMessageRecord
extends CustomPacketPayload {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC");
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);
    public static final Random RANDOM = new Random();

    public static boolean checkAccess(UUID uuid, ServerPlayer serverPlayer) {
        if (uuid == null || uuid.equals(EMPTY_UUID)) {
            log.error("Unable to get valid entity UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return false;
        }
        if (serverPlayer == null) {
            log.error("Unable to get valid player for entity with UUID {}", (Object)uuid);
            return false;
        }
        EasyNPC<?> easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
        if (easyNPC == null) {
            log.error("Unable to get valid entity with UUID {} for {}", (Object)uuid, (Object)serverPlayer);
            return false;
        }
        if (!LivingEntityManager.hasAccess(uuid, serverPlayer)) {
            log.error("User {} has no access to Easy NPC with uuid {}.", (Object)serverPlayer, (Object)uuid);
            return false;
        }
        return true;
    }

    public ResourceLocation id();

    public void write(FriendlyByteBuf var1);

    default public FriendlyByteBuf payload() {
        FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(Unpooled.buffer());
        this.write(friendlyByteBuf);
        return friendlyByteBuf;
    }

    default public void handleClient() {
        log.error("Network message client handler not implemented for {}", (Object)this);
    }

    default public void handleServer(ServerPlayer serverPlayer) {
        log.error("Network message server handler not implemented for {}", (Object)this);
    }

    default public EasyNPC<?> getEasyNPC(UUID uuid, ServerPlayer serverPlayer) {
        if (uuid == null || uuid.equals(EMPTY_UUID)) {
            log.error("Invalid Easy NPC UUID {} from {}", (Object)uuid, (Object)serverPlayer);
            return null;
        }
        if (serverPlayer == null) {
            log.error("Invalid server player for Easy NPC with UUID {}", (Object)uuid);
            return null;
        }
        return LivingEntityManager.getEasyNPCEntityByUUID(uuid, serverPlayer);
    }

    default public EasyNPC<?> getEasyNPCAndCheckAccess(UUID uuid, ServerPlayer serverPlayer) {
        return NetworkMessageRecord.checkAccess(uuid, serverPlayer) ? this.getEasyNPC(uuid, serverPlayer) : null;
    }
}

