/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPart;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;

public record ChangeModelPositionMessage(UUID uuid, ModelPart modelPart, CustomPosition position) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"change_model_position");
    public static final CustomPacketPayload.Type<ChangeModelPositionMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeModelPositionMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeModelPositionMessage::create);

    public static ChangeModelPositionMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelPositionMessage(buffer.readUUID(), (ModelPart)buffer.readEnum(ModelPart.class), new CustomPosition(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.modelPart);
        buffer.writeFloat(this.position.x());
        buffer.writeFloat(this.position.y());
        buffer.writeFloat(this.position.z());
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPart == null) {
            log.error("Invalid modelPart for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.position == null) {
            log.error("Invalid position for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ModelData<?> modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} position to {}\u00b0 for {} from {}", (Object)this.modelPart, (Object)this.position, easyNPC, (Object)serverPlayer);
        if (this.modelPart != ModelPart.ROOT) {
            easyNPC.getEntity().setPose(Pose.STANDING);
            modelData.setModelPose(ModelPose.CUSTOM);
        }
        modelData.setModelPartPosition(this.modelPart, this.position);
        if (!modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
        }
    }
}

