/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeProfessionMessage(UUID uuid, Profession profession) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"change_profession");
    public static final CustomPacketPayload.Type<ChangeProfessionMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeProfessionMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeProfessionMessage::create);

    public static ChangeProfessionMessage create(FriendlyByteBuf buffer) {
        return new ChangeProfessionMessage(buffer.readUUID(), (Profession)buffer.readEnum(Profession.class));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.profession);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.profession == null) {
            log.error("Invalid profession for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        ProfessionData<?> professionData = easyNPC.getEasyNPCProfessionData();
        if (professionData == null) {
            log.error("Invalid profession data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change profession {} for {} from {}", (Object)this.profession, easyNPC, (Object)serverPlayer);
        professionData.setProfession(this.profession);
    }
}

