/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.RenderHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public record ChangeRendererMessage(UUID uuid, RenderType renderType, Optional<EntityType<?>> renderEntityType) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"change_renderer");
    public static final CustomPacketPayload.Type<ChangeRendererMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeRendererMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeRendererMessage::create);

    public static ChangeRendererMessage create(FriendlyByteBuf buffer) {
        return new ChangeRendererMessage(buffer.readUUID(), (RenderType)buffer.readEnum(RenderType.class), EntityType.byString((String)buffer.readUtf()));
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.renderType);
        buffer.writeUtf(this.renderEntityType.map(entityType -> EntityType.getKey((EntityType)entityType).toString()).orElse(""));
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.renderType != null) {
            RenderHandler.setRenderType(easyNPC, this.renderType);
        }
        this.renderEntityType.ifPresent(entityType -> RenderHandler.setRenderEntity(easyNPC, (EntityType<? extends Entity>)entityType));
    }
}

