/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogButtonType;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record OpenDialogButtonEditorMessage(UUID uuid, UUID dialogId, UUID dialogButtonId) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"open_dialog_button_editor");
    public static final CustomPacketPayload.Type<OpenDialogButtonEditorMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenDialogButtonEditorMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), OpenDialogButtonEditorMessage::create);

    public static OpenDialogButtonEditorMessage create(FriendlyByteBuf buffer) {
        return new OpenDialogButtonEditorMessage(buffer.readUUID(), buffer.readUUID(), buffer.readUUID());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.dialogId);
        buffer.writeUUID(this.dialogButtonId);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid dialog data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataSet dialogDataSet = dialogData.getDialogDataSet();
        if (dialogDataSet == null) {
            log.error("Unable to get valid dialog data set for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataEntry dialogDataEntry = dialogDataSet.getDialog(this.dialogId);
        if (dialogDataEntry == null) {
            log.error("Unable to get valid dialog data for dialog {} for {} from {}", easyNPC, (Object)this.dialogId, (Object)serverPlayer);
            return;
        }
        UUID newDialogButtonId = this.dialogButtonId;
        if (this.dialogButtonId != null && this.dialogButtonId.equals(EMPTY_UUID)) {
            DialogButtonEntry newDialogButton = new DialogButtonEntry("Button " + RANDOM.nextInt(1000), DialogButtonType.DEFAULT);
            log.info("Created new dialog button {} for dialog {} for {} from {}", (Object)newDialogButton, (Object)this.dialogId, easyNPC, (Object)serverPlayer);
            dialogDataEntry.setDialogButton(newDialogButton);
            newDialogButtonId = newDialogButton.id();
        } else if (this.dialogButtonId != null && !dialogData.hasDialogButton(this.dialogId, this.dialogButtonId)) {
            log.error("Invalid dialog button id {} for {} from {}", (Object)this.dialogButtonId, easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Open dialog button editor for dialog {} and button {} for {} from {}", (Object)this.dialogId, (Object)newDialogButtonId, easyNPC, (Object)serverPlayer);
        MenuManager.getMenuHandler().openEditorMenu(EditorType.DIALOG_BUTTON, serverPlayer, easyNPC, this.dialogId, newDialogButtonId, 0);
    }
}

