/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogData;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record RemoveDialogButtonMessage(UUID uuid, UUID dialogId, UUID dialogButtonId) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"remove_dialog_button");
    public static final CustomPacketPayload.Type<RemoveDialogButtonMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveDialogButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), RemoveDialogButtonMessage::create);

    public static RemoveDialogButtonMessage create(FriendlyByteBuf buffer) {
        return new RemoveDialogButtonMessage(buffer.readUUID(), buffer.readUUID(), buffer.readUUID());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.dialogId);
        buffer.writeUUID(this.dialogButtonId);
    }

    @Override
    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC<?> easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonId == null) {
            log.error("Invalid dialog button id for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        DialogData<?> dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId) || !dialogData.hasDialogButton(this.dialogId, this.dialogButtonId)) {
            log.error("Unknown delete dialog request for dialog button {} for dialog {} for {} from {}", (Object)this.dialogButtonId, (Object)this.dialogId, easyNPC, (Object)serverPlayer);
            return;
        }
        if (dialogData.removeDialogButton(this.dialogId, this.dialogButtonId)) {
            log.info("Removed dialog button {} from dialog {} for {} from {}", (Object)this.dialogButtonId, (Object)this.dialogId, easyNPC, (Object)serverPlayer);
        } else {
            log.warn("Unable to remove dialog button {} from dialog {} for {} from {}", (Object)this.dialogButtonId, (Object)this.dialogId, easyNPC, (Object)serverPlayer);
        }
    }
}

