/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.block;

import codechicken.enderstorage.block.BlockEnderStorage;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.enderstorage.misc.EnderKnobSlot;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.MultiIndexedVoxelShape;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import com.google.common.collect.ImmutableSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockEnderChest
extends BlockEnderStorage {
    private static final IndexedVoxelShape CHEST = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)new Cuboid6(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375)), (Object)0);
    private static final IndexedVoxelShape[][] BUTTONS = new IndexedVoxelShape[4][3];
    private static final IndexedVoxelShape[] LATCH = new IndexedVoxelShape[4];
    private static final VoxelShape[][] SHAPES = new VoxelShape[4][2];
    public static final Transformation[] buttonT = new Transformation[3];

    public BlockEnderChest(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        IndexedVoxelShape shape = CHEST;
        BlockEntity t = worldIn.getBlockEntity(pos);
        if (t instanceof TileEnderChest) {
            TileEnderChest tile = (TileEnderChest)t;
            shape = SHAPES[tile.rotation][tile.getRadianLidAngle(0.0f) >= 0.0 ? 0 : 1];
        }
        return shape;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEnderChest(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return BlockEnderChest.createTickerHelper(p_153214_, (BlockEntityType)((BlockEntityType)EnderStorageModContent.ENDER_CHEST_TILE.get()), (level, pos, state, tile) -> tile.tick());
    }

    static {
        for (int button = 0; button < 3; ++button) {
            BlockEnderChest.buttonT[button] = new Translation(-0.1875 + 0.1875 * (double)button, 0.875, 0.0);
        }
        for (int rot = 0; rot < 4; ++rot) {
            for (int button = 0; button < 3; ++button) {
                Cuboid6 cuboid = TileFrequencyOwner.SELECTION_BUTTON.copy();
                cuboid.apply(buttonT[button]);
                cuboid.apply((Transformation)new Translation(0.5, 0.0, 0.5));
                cuboid.apply(new Rotation((double)(-90 * rot) * 0.017453292519943, Vector3.Y_POS).at(new Vector3(0.5, 0.0, 0.5)));
                BlockEnderChest.BUTTONS[rot][button] = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)cuboid), (Object)(button + 1));
            }
            BlockEnderChest.LATCH[rot] = new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)new Cuboid6(new EnderKnobSlot(rot).getSelectionBB())), (Object)4);
            for (int state = 0; state < 2; ++state) {
                ImmutableSet.Builder cuboids = ImmutableSet.builder();
                cuboids.add((Object)CHEST);
                if (state == 0) {
                    cuboids.add(BUTTONS[rot]);
                    cuboids.add((Object)LATCH[rot]);
                }
                BlockEnderChest.SHAPES[rot][state] = new MultiIndexedVoxelShape((VoxelShape)CHEST, cuboids.build());
            }
        }
    }
}

