/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.research.particles;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.description.general.particles.base.ParticleData;
import it.hurts.sskirillss.relics.utils.data.GUIRenderer;
import it.hurts.sskirillss.relics.utils.data.SpriteAnchor;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SmokeParticleData
extends ParticleData {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/relic/particles/smoke.png");
    private final float fadeInPercentage;

    public SmokeParticleData(float xStart, float yStart, float scale, int lifeTime, float fadeInPercentage) {
        super(TEXTURE, new Color(1.0f, 1.0f, 1.0f), xStart, yStart, scale, lifeTime);
        this.fadeInPercentage = fadeInPercentage;
    }

    @Override
    public void tick(Screen screen) {
        super.tick(screen);
        LocalPlayer player = screen.getMinecraft().player;
        if (player == null) {
            return;
        }
        float lifePercentage = (float)this.getLifeTime() / (float)this.getMaxLifeTime();
        this.setX(this.getX() + this.getDeltaX() * lifePercentage);
        this.setY(this.getY() + this.getDeltaY() * lifePercentage);
    }

    @Override
    public void render(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        float lifePercentage = (float)this.getLifeTime() / (float)this.getMaxLifeTime();
        float maxScale = this.getScale();
        float ratio = 1.0f - lifePercentage;
        float scale = ratio <= this.fadeInPercentage ? maxScale * (ratio / this.fadeInPercentage) : maxScale;
        poseStack.pushPose();
        RenderSystem.setShaderColor((float)((float)this.getColor().getRed() / 255.0f), (float)((float)this.getColor().getGreen() / 255.0f), (float)((float)this.getColor().getBlue() / 255.0f), (float)(lifePercentage * 0.75f));
        RenderSystem.enableBlend();
        poseStack.translate(Mth.lerp((float)partialTick, (float)this.getXO(), (float)this.getX()), Mth.lerp((float)partialTick, (float)this.getYO(), (float)this.getY()), 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(((float)this.getLifeTime() + partialTick) * lifePercentage));
        GUIRenderer.begin(TEXTURE, guiGraphics.pose()).scale(scale).anchor(SpriteAnchor.CENTER).end();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        poseStack.popPose();
    }
}

